/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _LOCATIONDIALOG_HPP_
#define _LOCATIONDIALOG_HPP_

#include "ui_LocationDialog.h"

#include <QDialog>
#include <QAbstractItemModel>

#include "StelLocation.hpp"

class StelLocation;
class QMaemo5ListPickSelector;
class QVariant;
class QListView;
class QStringListModel;
class MobileLocationMgr;

class LocationDialog : public QDialog, private Ui_LocationDialog
{
	Q_OBJECT

public:
	Q_INVOKABLE LocationDialog(QWidget *parent=0);

private slots:
	void pickCity();
	void updateAll();
	void showManual();
	void showPickCity();
	
protected:
	QString latitudeRepr(double latitude) const;
	QString longitudeRepr(double longitude) const;

private:
	QMaemo5ListPickSelector* citySelector;
	MobileLocationMgr* locMgr;
};

//! A dialog that allow us to pick a city from a list
class PickCity : public QDialog
{
	Q_OBJECT

public:
	PickCity(const StelLocation& loc);
	StelLocation getLocation() const;
protected:
	void updateCities();

private slots:
	void onPickCountry();
	void onPickCity();

private:
	StelLocation location;
	QPushButton* countryButton;
	QPushButton* cityButton;
};

#endif // _LOCATIONDIALOG_HPP_
