/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _LISTPICKER_HPP_
#define _LISTPICKER_HPP_

#include <QDialog>
#include <QStringListModel>

#include "ui_ListPicker.h"

//! @class ListPicker
//! A Dialog that shows a list of Strings, with an additional listView to
//! filter the values.
class ListPicker : public QDialog, private Ui_ListPicker
{
	Q_OBJECT
public:
	ListPicker(const QString& title, QStringListModel* model, QWidget* parent);
	QString getValue() const {return value;}
	void select(const QString& value);

signals:
	void selected(const QString& value);

private slots:
	void onActivated(const QModelIndex& index);

private:
	QString value;
};

#endif // _LISTPICKER_HPP_
