/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "LabelsDialog.hpp"
#include "StarMgr.hpp"
#include "StelModuleMgr.hpp"
#include "StelApp.hpp"
#include "StelGuiBase.hpp"
#include "NebulaMgr.hpp"
#include "SolarSystem.hpp"

#include "MobileGui.hpp"

#include <QAction>

LabelsDialog::LabelsDialog(QWidget* parent) : QWidget(parent)
{
	StelGuiBase* gui = StelApp::getInstance().getGui();
	setWindowFlags(windowFlags() | Qt::Window);
#ifdef Q_WS_MAEMO_5
	setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
	setupUi(this);

	StarMgr* smgr = GETSTELMODULE(StarMgr);
	starLabelCheckBox->setChecked(smgr->getFlagLabels());
	connect(starLabelCheckBox, SIGNAL(toggled(bool)), smgr, SLOT(setFlagLabels(bool)));

	// StelGuiBase* gui = StelApp::getInstance().getGui();
	NebulaMgr* nmgr = GETSTELMODULE(NebulaMgr);
	nebulaLabelCheckBox->setChecked(nmgr->getFlagHints());
	QAction* a = gui->getGuiActions("actionShow_Nebulas");
	connect(a, SIGNAL(toggled(bool)), nebulaLabelCheckBox, SLOT(setChecked(bool)));
	connect(nebulaLabelCheckBox, SIGNAL(toggled(bool)), a, SLOT(setChecked(bool)));

	SolarSystem* ssmgr = GETSTELMODULE(SolarSystem);
	planetLabelCheckBox->setChecked(ssmgr->getFlagLabels());
	connect(planetLabelCheckBox, SIGNAL(toggled(bool)), ssmgr, SLOT(setFlagLabels(bool)));

	starsLabelsHorizontalSlider->setValue((int)(smgr->getLabelsAmount()*10.f));
	connect(starsLabelsHorizontalSlider, SIGNAL(valueChanged(int)), this, SLOT(starsLabelsValueChanged(int)));
	planetsLabelsHorizontalSlider->setValue((int)(ssmgr->getLabelsAmount()*10.f));
	connect(planetsLabelsHorizontalSlider, SIGNAL(valueChanged(int)), this, SLOT(planetsLabelsValueChanged(int)));
	nebulasLabelsHorizontalSlider->setValue((int)(nmgr->getHintsAmount()*10.f));
	connect(nebulasLabelsHorizontalSlider, SIGNAL(valueChanged(int)), this, SLOT(nebulasLabelsValueChanged(int)));
}


void LabelsDialog::planetsLabelsValueChanged(int v)
{
	SolarSystem* ssmgr = GETSTELMODULE(SolarSystem);
	float a= ((float)v)/10.f;
	ssmgr->setLabelsAmount(a);
}

void LabelsDialog::nebulasLabelsValueChanged(int v)
{
	NebulaMgr* nmgr = GETSTELMODULE(NebulaMgr);
	float a= ((float)v)/10.f;
	nmgr->setHintsAmount(a);
	nmgr->setLabelsAmount(a);
}

void LabelsDialog::starsLabelsValueChanged(int v)
{
	StarMgr* smgr = GETSTELMODULE(StarMgr);
	float a= ((float)v)/10.f;
	smgr->setLabelsAmount(a);
}
