/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */


#ifndef _DATETIMEDIALOG_HPP_
#define _DATETIMEDIALOG_HPP_

#include <QDialog>

class QMaemo5DatePickSelector;
class QMaemo5TimePickSelector;

class DateTimeDialog : public QDialog
{
	Q_OBJECT
public:
	Q_INVOKABLE DateTimeDialog(QWidget *parent=0);
	// double newJd();
	// bool valid(int y, int m, int d, int h, int min, int s);

protected:
	void setDateTime(double newJd);

private slots:
	void valueChanged();
	void setForwardTimeAtStartup(bool b);
	
private:
	QMaemo5DatePickSelector* datePickSelector;
	QMaemo5TimePickSelector* timePickSelector;
};

#endif // _DATETIMEDIALOG_HPP_
