/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "CelestialSphereMarkingDialog.hpp"
#include "MobileGui.hpp"

#include "StelApp.hpp"
#include "StelModuleMgr.hpp"
#include "GridLinesMgr.hpp"
#include "LandscapeMgr.hpp"
#include "StelTranslator.hpp"

#include <QLayout>
#include <QCheckBox>
#include <QScrollArea>
#include <QAction>

CelestialSphereMarkingDialog::CelestialSphereMarkingDialog(QWidget* parent) : QWidget(parent)
{
	setWindowFlags(windowFlags() | Qt::Window);
#ifdef Q_WS_MAEMO_5
	setAttribute(Qt::WA_Maemo5StackedWindow);
#endif

	setWindowTitle("celestial sphere");
	QVBoxLayout* vLayout = new QVBoxLayout(this);
	QGridLayout* layout = new QGridLayout;
	vLayout->addLayout(layout);

	// QVBoxLayout* layout = new QVBoxLayout(central);
	QCheckBox* showEquatorialGridCheckBox = new QCheckBox(q_("Equatorial grid"));
	layout->addWidget(showEquatorialGridCheckBox, 0, 0);
	QCheckBox* showAzimuthalGridCheckBox = new QCheckBox(q_("Azimuthal grid"));
	layout->addWidget(showAzimuthalGridCheckBox, 1, 0);
	QCheckBox *showCardinalPointsCheckBox = new QCheckBox(q_("Cardinal points"));
	layout->addWidget(showCardinalPointsCheckBox, 2, 0);
	QCheckBox* showEquatorLineCheckBox = new QCheckBox(q_("Equator line"));
	layout->addWidget(showEquatorLineCheckBox, 0, 1);
	QCheckBox *showMeridianLineCheckBox = new QCheckBox(q_("Meridian line"));
	layout->addWidget(showMeridianLineCheckBox, 1, 1);
	QCheckBox *showEclipticLineCheckBox = new QCheckBox(q_("Ecliptic line"));
	layout->addWidget(showEclipticLineCheckBox, 2, 1);


	vLayout->addStretch();

	// connect all the signals
	GridLinesMgr* glmgr = GETSTELMODULE(GridLinesMgr);
	LandscapeMgr* lmgr = GETSTELMODULE(LandscapeMgr);

	StelGuiBase* gui = StelApp::getInstance().getGui();
	QAction* a;

	showEquatorLineCheckBox->setChecked(glmgr->getFlagEquatorLine());
	a = gui->getGuiActions("actionShow_Equator_Line");	
	connect(a, SIGNAL(toggled(bool)), showEquatorLineCheckBox, SLOT(setChecked(bool)));
	connect(showEquatorLineCheckBox, SIGNAL(toggled(bool)), a, SLOT(setChecked(bool)));

	showEclipticLineCheckBox->setChecked(glmgr->getFlagEclipticLine());
	a = gui->getGuiActions("actionShow_Ecliptic_Line");
	connect(a, SIGNAL(toggled(bool)), showEclipticLineCheckBox, SLOT(setChecked(bool)));
	connect(showEclipticLineCheckBox, SIGNAL(toggled(bool)), a, SLOT(setChecked(bool)));

	showMeridianLineCheckBox->setChecked(glmgr->getFlagMeridianLine());
	a = gui->getGuiActions("actionShow_Meridian_Line");
	connect(a, SIGNAL(toggled(bool)), showMeridianLineCheckBox, SLOT(setChecked(bool)));
	connect(showMeridianLineCheckBox, SIGNAL(toggled(bool)), a, SLOT(setChecked(bool)));

	showEquatorialGridCheckBox->setChecked(glmgr->getFlagEquatorGrid());
	a = gui->getGuiActions("actionShow_Equatorial_Grid");
	connect(a, SIGNAL(toggled(bool)), showEquatorialGridCheckBox, SLOT(setChecked(bool)));
	connect(showEquatorialGridCheckBox, SIGNAL(toggled(bool)), a, SLOT(setChecked(bool)));

	showAzimuthalGridCheckBox->setChecked(glmgr->getFlagAzimuthalGrid());
	a = gui->getGuiActions("actionShow_Azimuthal_Grid");
	connect(a, SIGNAL(toggled(bool)), showAzimuthalGridCheckBox, SLOT(setChecked(bool)));
	connect(showAzimuthalGridCheckBox, SIGNAL(toggled(bool)), a, SLOT(setChecked(bool)));

	showCardinalPointsCheckBox->setChecked(lmgr->getFlagCardinalsPoints());
	a = gui->getGuiActions("actionShow_Cardinal_Points");
	connect(a, SIGNAL(toggled(bool)), showCardinalPointsCheckBox, SLOT(setChecked(bool)));
	connect(showCardinalPointsCheckBox, SIGNAL(toggled(bool)), a, SLOT(setChecked(bool)));
}
