/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "AtmosphereDialog.hpp"

#include "StelGuiBase.hpp"
#include "StelApp.hpp"
#include "LandscapeMgr.hpp"
#include "StelModuleMgr.hpp"
#include "StelCore.hpp"
#include "StelSkyDrawer.hpp"

#include "MobileGui.hpp"

AtmosphereDialog::AtmosphereDialog(QWidget* parent) : QWidget(parent)
{
	StelGuiBase* gui = StelApp::getInstance().getGui();
	Q_ASSERT(gui);
	setWindowFlags(windowFlags() | Qt::Window);
#ifdef Q_WS_MAEMO_5
	setAttribute(Qt::WA_Maemo5StackedWindow);
#endif

	setupUi(this);

	LandscapeMgr* lmgr = GETSTELMODULE(LandscapeMgr);
	showAtmosphereCheckBox->setChecked(lmgr->getFlagAtmosphere());
	QAction* a = gui->getGuiActions("actionShow_Atmosphere");
	connect(a, SIGNAL(toggled(bool)), showAtmosphereCheckBox, SLOT(setChecked(bool)));
	connect(showAtmosphereCheckBox, SIGNAL(toggled(bool)), a, SLOT(setChecked(bool)));

	lightPollutionSpinBox->setValue(StelApp::getInstance().getCore()->getSkyDrawer()->getBortleScale());
	connect(lightPollutionSpinBox, SIGNAL(valueChanged(int)), lmgr, SLOT(setAtmosphereBortleLightPollution(int)));
	connect(lightPollutionSpinBox, SIGNAL(valueChanged(int)), StelApp::getInstance().getCore()->getSkyDrawer(), SLOT(setBortleScale(int)));
}
