/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef TIMEBAR_HPP
#define TIMEBAR_HPP

#include <QGraphicsWidget>
class ImageButton;

class TimeBar : public QGraphicsWidget
{
	Q_OBJECT

public:
	TimeBar(QGraphicsItem* parent=NULL, class HelpMessage* msg=NULL);
	void updateText();
	void setIsTimeDragging(bool b) {isTimeDragging=b;}
	
protected:
	virtual void mousePressEvent(QGraphicsSceneMouseEvent* event);

private:
	QGraphicsSimpleTextItem* textItem;
	QGraphicsSimpleTextItem* timeSpeedTextItem;
	ImageButton* btTimeNow;
	ImageButton* btTimeReal;
	bool isTimeDragging;
};

#endif // TIMEBAR_HPP
