/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef MOBILELOCATIONMGR_HPP
#define MOBILELOCATIONMGR_HPP

#include <QObject>
#include "StelLocation.hpp"

class MobileLocationMgr : public QObject
{
    Q_OBJECT
public:
    explicit MobileLocationMgr(QObject *parent = 0);
	bool getUseGps() const {return useGps;}
	bool hasGps() const;
	
	enum Status {
		StatusStopped,
		StatusSearching,
		StatusError,
		StatusFound,
		StatusRefining
	};
	
	Status getStatus() const {return currentStatus;}
	
signals:
	void changed();
	
public slots:
	void moveObserverTo(const StelLocation& location);
	void moveToManualLocation(double latitude, double longitude);
	void setUseGps(bool b);
	
private slots:
	void gpsFixReceived();
	
private:
	StelLocation lastGpsLocation;
	StelLocation manualLocation;
	bool useGps;
	Status currentStatus;
};

#endif // MOBILELOCATIONMGR_HPP
