/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef INFOPANEL_HPP
#define INFOPANEL_HPP

#include "StelGuiBase.hpp"
#include "StelModule.hpp"
#include <QGraphicsWidget>

class QGraphicsSimpleTextItem;
class ImageButton;
class ButtonGroup;

//! Module that creates and update the info panel of the GUI.
class InfoPanelMgr : public StelModule
{
	Q_OBJECT
public:
	InfoPanelMgr();

	// Methods defined in the StelModule class
	virtual void init();
	virtual void draw(StelCore*) {;}
	virtual void update(double deltaTime);
	// We want it to be called before anything else.
	virtual double getCallOrder(StelModuleActionName) const {return 1000;}

	bool getHasSelectedInfo() const {return hasSelectedInfo;}
	void setInfoTextFilters(const StelObject::InfoStringGroup& aflags) {infoTextFilters=aflags;}
	const StelObject::InfoStringGroup& getInfoTextFilters(void) const {return infoTextFilters;}

signals:
	void toggled(bool b);
	void htmlChanged(QString html);
	void trackingModeChanged();
	
private:
	bool hasSelectedInfo;
	QString previousText;
	StelObject::InfoStringGroup infoTextFilters;
	float lastUpdateTime;
	bool previousTracking;
};


//! The informations about the currently selected object
class InfoPanel : public QGraphicsWidget
{
	Q_OBJECT
public:
	InfoPanel(QGraphicsItem* parent, class HelpMessage* msg);
protected:
	virtual void mousePressEvent(QGraphicsSceneMouseEvent* event);

private slots:
	void toggledChanged(bool b);
	void htmlChanged(QString html);
	void setShowMoreInfo(bool b);
	void refreshButtonGroup();
	
private:
	QGraphicsSimpleTextItem* detailsTextItem;
	QGraphicsSimpleTextItem* titleTextItem;
	
	ImageButton* btMoreObjectInfo;
	ImageButton* btCenterOnObject;
	ImageButton* btAutoZoomIn;
	ImageButton* btAutoZoomOut;
	ButtonGroup* btgrp;
};

#endif // INFOPANEL_HPP
