/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef IMAGEBUTTON_HPP
#define IMAGEBUTTON_HPP

#include <QGraphicsWidget>

class QAction;
class QGraphicsBlurEffect;
class HelpMessage;

class ImageButton : public QGraphicsWidget
{
	Q_OBJECT

public:
	ImageButton(const QString& image, QAction* action=NULL, QGraphicsItem* parent=NULL,
				const QString& haloImage="", HelpMessage* helpMsg=NULL);

signals:
	void toggled(bool checked);
	void triggered();

protected:
	QSizeF sizeHint ( Qt::SizeHint which, const QSizeF & constraint = QSizeF() ) const;
	virtual void mousePressEvent (QGraphicsSceneMouseEvent* event);
	virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent* event);
	virtual void hoverLeaveEvent(QGraphicsSceneHoverEvent* event);

public slots:
	void setChecked(bool b);

private:
signals:
	void toggledTrue();
	void toggledFalse();
	
private:
	QAction* action;
	QGraphicsPixmapItem* icon;
	QGraphicsPixmapItem* hoverHalo;
	bool checkable;
	bool checked;
	HelpMessage* helpMsg;
};

#endif // IMAGEBUTTON_HPP
