/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _GPS_HPP_
#define _GPS_HPP_

#include <QObject>

#ifdef Q_WS_MAEMO_5

#include <location/location-gps-device.h>
#include <location/location-gpsd-control.h>
class Gps : public QObject
{
	Q_OBJECT

public:
	~Gps();
	static Gps* getInstance();
	bool isAvailable() const {return available;}
	bool lastKnownPosition(double* lon, double* lat, double* alt, double* precision);

	void fixReceived();
signals:
	void positionUpdate();

public slots:
	void start();
	void stop();

protected:
	Gps();

private:
	static Gps* gps;
	bool available;
	bool wasFixReceived;
	LocationGPSDControl *control;
	LocationGPSDevice *device;
};
#endif
#endif // _GPS_HPP_
