/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "ButtonGroup.hpp"
#include "ImageButton.hpp"
#include <QGraphicsLinearLayout>

ButtonGroup::ButtonGroup(QGraphicsItem* parent) : QGraphicsWidget(parent), layout(NULL)
{
	layout = new QGraphicsLinearLayout(Qt::Horizontal, this);
	layout->setSpacing(5);
	layout->setContentsMargins(0, 0, 0, 0);
	setContentsMargins(0, 0, 0, 0);
}

void ButtonGroup::add(ImageButton* button)
{
	layout->addItem(button);
}

void ButtonGroup::clear()
{
	while (layout->count()>0)
	{
		layout->removeItem(layout->itemAt(0));
	}
}
