/*
 * status-area-applet-mediaplayer
 *
 * Copyright (C) 2010 Faheem Pervez <trippin1@gmail.com>. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *      
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *      
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 */

/* status-area-applet-mediaplayer.vala/.c */

using Mafw;
using Gtk;
using Hildon;

const string WANTED_RENDERER = "Mafw-Gst-Renderer";
const string WANTED_SOURCE = "Mafw-Tracker-Source";

private class MediaPlayerStatusMenuItem : HD.StatusMenuItem
{
	private const string gettext_pkg = Config.GETTEXT_PACKAGE; /* Fuck you, Vala */
	private string mp_ti_launch_first;
	private string mp_ti_launch_second;
	private string mp_li_unknown_song;
	private string mp_li_unknown_artist;
	private Image mediaplayer_default_album;

	private Hildon.Button button;
	private Gtk.IconTheme theme;
	private Osso.Context context;
	private unowned Mafw.Registry registry;
	private Mafw.Renderer gst_renderer;
	private Mafw.Source tracker_source;
	private uint timeout_src;
	private string obj_id; /* Would prefer being able to do something like g_object_set_data ()... */

	private inline void set_default_album_picture ()
	{
		button.set_image(mediaplayer_default_album);	
	}
	
	private void button_set_launch_labels ()
	{
		button.set_title(mp_ti_launch_first);
		button.set_value(mp_ti_launch_second);
	}
	
	private void button_set_song_labels_and_picture (string? label = null, string? @value = null, string? picuri = null)
	{
		button.set_title(label ?? mp_li_unknown_song);
		button.set_value(value ?? mp_li_unknown_artist);		
		string? picture = picuri != null ? Filename.from_uri(picuri) : picuri; 

		if (picture == null)
			set_default_album_picture ();
		else
		{
			Gdk.Pixbuf pixbuf = new Gdk.Pixbuf.from_file_at_scale(picture, 48, 48, true);
			Image image = new Image.from_pixbuf(pixbuf);
			button.set_image(image);			
		}
	}

	private bool /* SourceFunc */ update_shit ()
		//requires (tracker_source != null) /* timeout_src won't get set back to 0 */
	{
		SourceMetadataResultCb metadata_cb = (source, object_id, metadata) => {
			weak string artist = metadata_first(metadata, "artist").get_string ();
			weak string title = metadata_first(metadata, "title").get_string ();
			weak string album = metadata_first(metadata, "album-art-small-uri").get_string ();

			button_set_song_labels_and_picture (title, artist, album);
		};

		if (tracker_source == null)
		{
			timeout_src = 0;
			return false;
		}

		weak string metadata_keys[4];
		metadata_keys[0] = "artist";
		metadata_keys[1] = "title";
		metadata_keys[2] = "album-art-small-uri";
		metadata_keys[3] = null;

		tracker_source.get_metadata(obj_id, metadata_keys, metadata_cb);

		timeout_src = 0;
		return false;
	}
	
	private void renderer_on_media_changed (int index, string object_id)
	{
		if (timeout_src != 0)
		{
			GLib.Source.remove(timeout_src);
			timeout_src = 0;
		}

		obj_id = object_id;
		timeout_src = Timeout.add(100, update_shit); /* Fuckin' Vala: *Don't* cast update_shit to (SourceFunc) */
	}

	private void registry_on_renderer_added (Mafw.Renderer renderer)
	{
		RendererStatusCB renderer_status_cb = (self, playlist, index, state, object_id) => {
			renderer_on_media_changed ((int) index, object_id);
		};

		if (renderer.get_name() == WANTED_RENDERER)
		{
			gst_renderer = renderer;
			gst_renderer.media_changed += renderer_on_media_changed;
			gst_renderer.get_status (renderer_status_cb);
		}
	}

	private void registry_on_renderer_removed (Mafw.Renderer renderer)
	{
		if (renderer == gst_renderer)
			gst_renderer = null;
	}
	
	private void registry_on_source_added (Mafw.Source source)
	{
		if (source.get_name() == WANTED_SOURCE)
			tracker_source = source;
	}

	private void registry_on_source_removed (Mafw.Source source)
	{
		if (source == tracker_source)
			tracker_source = null;
	}

	construct
	{
		unowned GLib.List<Mafw.Renderer> rend_list;
		unowned GLib.List<Mafw.Source> src_list;
				
		Intl.setlocale (LocaleCategory.ALL, "");
		Intl.bindtextdomain (gettext_pkg, Config.LOCALEDIR);
		Intl.textdomain (gettext_pkg);

		timeout_src = 0;

		mp_ti_launch_first = IntlPimped.dgettext("mediaplayer", "mp_ti_launch_first");
		mp_ti_launch_second = IntlPimped.dgettext("mediaplayer", "mp_ti_launch_second");
		mp_li_unknown_song = IntlPimped.dgettext("mediaplayer", "mp_li_unknown_song");
		mp_li_unknown_artist = IntlPimped.dgettext("mediaplayer", "mp_li_unknown_artist");

		theme = IconTheme.get_default();
		context = new Osso.Context (Config.PACKAGE, Config.VERSION, false, null);

		mediaplayer_default_album = new Image.from_pixbuf(theme.load_icon("mediaplayer_default_album", 64, IconLookupFlags.NO_SVG).scale_simple(48, 48, Gdk.InterpType.BILINEAR));
		
		button = new Hildon.Button (SizeType.FINGER_HEIGHT | SizeType.AUTO_WIDTH, ButtonArrangement.VERTICAL);
		button.set_alignment (0.0f, 0.5f, 1.0f, 1.0f);
		button.set_style (Hildon.ButtonStyle.PICKER);
		
		button_set_launch_labels ();
		set_default_album_picture ();
				
		button.clicked.connect (() => {
			//mediaplayer.open_mp_now_playing (); /* I love you, Vala */
			context.rpc_run("com.nokia.mediaplayer", "/com/nokia/osso/mediaplayer", "com.nokia.mediaplayer", "open_mp_now_playing", null, (int) '\0');
		});
		
		registry = registry.get_instance();
		shared_init (registry);
		
		registry.renderer_added += registry_on_renderer_added;
		registry.renderer_removed += registry_on_renderer_removed;
		registry.source_added += registry_on_source_added;
		registry.source_removed += registry_on_source_removed;
		
		rend_list = registry.get_renderers ();
		foreach (Mafw.Renderer renderer in rend_list)
			registry_on_renderer_added (renderer);
		
		src_list = registry.get_sources ();
		foreach (Mafw.Source source in src_list)
			registry_on_source_added (source);
		
		add (button);
		show_all();
	}
	
	~MediaPlayerStatusMenuItem ()
	{
		shared_deinit();
	}
}


/** 
 * Vala code can't use the HD_DEFINE_PLUGIN_MODULE macro, but it handles
 * most of the class registration issues itself. Only this code from
 * HD_PLUGIN_MODULE_SYMBOLS_CODE has to be has to be included manually
 * to register with hildon-desktop:
 */
[ModuleInit]
public void hd_plugin_module_load (TypeModule plugin)
{
	// [ModuleInit] registers types automatically
	((HD.PluginModule) plugin).add_type (typeof (MediaPlayerStatusMenuItem));
}

public void hd_plugin_module_unload (HD.PluginModule plugin) {}
