#include "maplistitem.h"

MapListItem::MapListItem(QListWidget* parent) : //,QString listType) :
        QListWidgetItem(parent,Type)
{
    QVariant variant;
    map_i=new QVariantMap();
    qVariantSetValue(variant,map_i);
    setData(MapItem,variant);
}


void MapListItem::setMap(QVariantMap map)
{
    QVariant variant;
    delete map_i;
    map_i=new QVariantMap(map);
    qVariantSetValue(variant,map_i);
    setData(MapItem,variant);
}

void MapListItem::setTitle(QString title)
{
    //qDebug() << "setTitle()" << property("title");
    if (!title.isEmpty()) {
        setText(title);
    } else if(property("type")==QString("nowplaying")) {
        setText(property("title")+" - "+property("artist"));
    }
    else if(property("type")==QString("albums")) {
        setText(property("album"));
    }
    else if(property("type")==QString("titles")) {
        setText(property("title"));
    }

    else if(property("type")==QString("artists")) {
        setText(property("artist"));
    }

    else if(property("type")==QString("playlists")) {
        setText(property("playlist"));
    }
    //qDebug() << "setTitle()" << QListWidgetItem::text();
}

void MapListItem::addProperty(QString key, QString val)
{
    //qDebug()<< "addProperty #1"<< key << val;
    (*map_i)[key]=val;
}

QString MapListItem::property(QString key)
{
    return(map_i->value(key).toString());
}

void MapListItem::setIcon()
{
    setIcon(QIcon(SMALLBULLETPIXMAPFILE));
}
