#include "libraryviewdialog.h"
#include "ui_libraryviewdialog.h"

libraryViewDialog::libraryViewDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::libraryViewDialog)
{
    ui->setupUi(this);
}

libraryViewDialog::~libraryViewDialog()
{
    delete ui;
}

void libraryViewDialog::initButtons(quint16 defaultButton)
{
    switch (defaultButton) {
    case 0 :
        ui->albumsRadioButton->setChecked(true);
        break;

    case 1 :
        ui->playlistsRadioButton->setChecked(true);
        break;

    case 2 :
        ui->titlesRadioButton->setChecked(true);
        break;


    case 3 :
        ui->artistsRadioButton->setChecked(true);
        break;

    }
}

void libraryViewDialog::on_albumsRadioButton_clicked()
{
    emit albums();
}

void libraryViewDialog::on_artistsRadioButton_clicked()
{
    emit artists();
}

void libraryViewDialog::on_playlistsRadioButton_clicked()
{
    emit playlists();
}

void libraryViewDialog::on_titlesRadioButton_clicked()
{
    emit titles();
}
