#ifndef OPTIONSDIALOG_H
#define OPTIONSDIALOG_H

#include <QDialog>
#include <QMessageBox>
#include "version.h"

namespace Ui {
    class OptionsDialog;
}

class OptionsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit OptionsDialog(QWidget *parent = 0);
    ~OptionsDialog();

    void setScreensaverInhibitedState(bool ssInhibited);
    void setLargeAlbumIconsState(bool largeAlbumIcons);
    void setAlbumIconsState(bool albumIcons);

signals:
    void clearCache();
    void ssaverInhibit(bool checked);
    void albumIcons(bool checked);
    void largeAlbumIcons(bool checked);

private slots:
    void on_clearCachePushButton_clicked();
    void on_ssaverCheckBox_toggled(bool checked);
    void on_albumIconsCheckBox_toggled(bool checked);
//    void on_largeAlbumIconsCheckBox_toggled(bool checked);
    void on_aboutPushButton_clicked();
    void on_buttonBox_accepted();

private:
    Ui::OptionsDialog *ui;
};

#endif // OPTIONSDIALOG_H
