#!/usr/bin/python -d
import os
import re
import sys
from PyQt4 import QtCore, QtGui, QtOpenGL
from PyQt4.QtCore import QTimer
from gui import Ui_MainWindow as Ui_Form


import localization as vc
from radio_modules import ID_from_MAC


class vcUpdate(QtCore.QThread):

    def run(self):
        results = localization.update()
        self.emit(QtCore.SIGNAL("scanComplete(QString)"), str(results))


class mapWidget(QtOpenGL.QGLWidget):

    def __init__(self, parent):
        super(mapWidget, self).__init__(parent)
        self.painter = QtGui.QPainter()
        self.painter.setRenderHint(self.painter.Antialiasing, on = True)

        self.width = 750
        self.height = 300
        self.setGeometry(0, 0, self.width, self.height)
        self.graph = {'': (0, 0), 'b': (0, 1)}

    def initializeGL(self):
        print "initializeGL"

    def paintGL(self):
        pass

    def paintEvent(self, event = None):
        self.painter.begin(self)
        (r, g, b) = (255, 0, 0)
        for node in self.graph:
            color = QtGui.QColor(r, g, b)
            r = (r - 64) % 256
            g = (g + 16) % 256
            b = (b + 10) % 256
            self.painter.setBrush(QtGui.QBrush(color))
            self.painter.drawEllipse(self.graph[node][0]*10 + self.width/2, \
                            self.graph[node][1]*10 + self.height/2, 10, 10)
        self.painter.end()
        print "paintEvent"

    def setGraph(self, graph):
        self.graph = graph
        self.paintEvent()


class MyForm(QtGui.QMainWindow):

    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_Form()
        self.ui.setupUi(self)

        self.timer = QTimer(self)
        self.vcUpdater = vcUpdate(self)

        self.mapWidget = mapWidget(self.ui.graphView)

        QtCore.QObject.connect(self.timer, QtCore.SIGNAL("timeout()"), \
                                    self.scan)
        QtCore.QObject.connect(self.ui.pushButton_scan, \
                                    QtCore.SIGNAL("clicked()"), self.scan)
        QtCore.QObject.connect(self.ui.checkBox_periodic, \
                                    QtCore.SIGNAL("stateChanged(int)"), \
                                    self.setupPeriodicScan)
        QtCore.QObject.connect(self.vcUpdater, \
                                    QtCore.SIGNAL("scanComplete(QString)"), \
                                    self.displayScanResults)
        QtCore.QObject.connect(self.ui.pushButton_clear, \
                                    QtCore.SIGNAL("clicked()"), \
                                    self.ui.textBrowser_log.clear)

    def displayScanResults(self, results):
        self.ui.textBrowser_log.append(str(results))
        self.ui.textBrowser_log.append("")
        self.mapWidget.setGraph(eval(str(results)))

    def scan(self):
        self.vcUpdater.start()

    def setupPeriodicScan(self, state):
        if state == QtCore.Qt.Unchecked:
            self.stopPeriodicScan()
        else:
            self.startPeriodicScan()

    def startPeriodicScan(self):
        self.timer.setInterval(int(self.ui.lineEdit_interval.text()) * 1000)
        self.timer.start()

    def stopPeriodicScan(self):
        self.timer.stop()

if __name__ == "__main__":
    app = QtGui.QApplication(sys.argv)
    myapp = MyForm()
    myapp.show()

    output = os.popen("ifconfig wlan0").readlines()
    for line in output:
        matches = re.search("HWaddr (.*)", line)
        if matches:
            MAC = matches.group(1)
            continue

    ID = ID_from_MAC(MAC)
    localization = vc.Localization(ID)

    sys.exit(app.exec_())
