/*
 * SomePlayer - An alternate music player for Maemo 5
 * Copyright (C) 2010 Nikolay (somebody) Tischenko <niktischenko@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "edittagsdialog.h"
#include "ui_edittagsdialog.h"
#include "trackmetainformation.h"

using namespace SomePlayer::DataObjects;

EditTagsDialog::EditTagsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::EditTagsDialog)
{
    ui->setupUi(this);
}

EditTagsDialog::~EditTagsDialog()
{
    delete ui;
}

void EditTagsDialog::setTrackMetadata(TrackMetadata meta) {
	_meta = meta;
	ui->artistLineEdit->setText(meta.artist());
	ui->albumLineEdit->setText(meta.album());
	ui->titleLineEdit->setText(meta.title());
}

TrackMetadata EditTagsDialog::meta() {
	_meta.setArtist(ui->artistLineEdit->text());
	_meta.setAlbum(ui->albumLineEdit->text());
	_meta.setTitle(ui->titleLineEdit->text());
	return _meta;
}

void EditTagsDialog::updateTranslations() {
	ui->retranslateUi(this);
}
