#include "progressitem.h"
#include "ui_progressitem.h"

ProgressItem::ProgressItem(QWidget *parent, QString text) :
    QWidget(parent),
    ui(new Ui::ProgressItem)
{
    ui->setupUi(this);
    if (!text.isEmpty())
        ui->label->setText(text);
}

ProgressItem::~ProgressItem()
{
    delete ui;
}

QProgressBar* ProgressItem::progressBar()
{
    return ui->progressBar;
}

void ProgressItem::setData(QVariant data)
{
    if (m_data != data)
        m_data = data;
}

QVariant ProgressItem::data()
{
    return m_data;
}

void ProgressItem::setText(QString text)
{
    ui->label->setText(text);
}

QString ProgressItem::text()
{
    return ui->label->text();
}
