#include "notificationitem.h"
#include "ui_notificationitem.h"

NotificationItem::NotificationItem(QWidget *parent, QString token, QNetworkAccessManager *nam) :
    QWidget(parent),
    ui(new Ui::NotificationItem),
    accessToken(token),
    nam(nam)
{
    ui->setupUi(this);
    ui->timeLabel->hide();
}

NotificationItem::~NotificationItem()
{
    delete ui;
}

void NotificationItem::markAsRead()
{
    QString url = QString("https://api.facebook.com/method/notifications.markRead?notification_ids="
                          + m_notificationId
                          + "&access_token="
                          + accessToken);

    m_markAsReadReply = nam->put(QNetworkRequest(url), QByteArray());
    connect(m_markAsReadReply, SIGNAL(finished()), this, SLOT(markAsReadReply()));
}

void NotificationItem::markAsReadReply()
{
    if (m_markAsReadReply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to mark notification as read";
        m_markAsReadReply->deleteLater();
        m_markAsReadReply = 0;

        return;
    }

    emit markedAsRead(this);

    /* Uncommenting this would make the UI show the notification in white (Maemo 5) again,
       See http://talk.maemo.org/showpost.php?p=1011857&postcount=303 for more... */
    /* this->setUnread(false); */
}

void NotificationItem::setUserId(QString id)
{
    m_userId = id;
    this->getAvatar();
}

void NotificationItem::setNotificationId(QString notificationId)
{
    m_notificationId = notificationId;
}

void NotificationItem::setUnread(bool isUnread)
{
    m_unread = isUnread;

    QPalette p = this->palette();
    if (isUnread) {
        p.setColor(QPalette::Foreground, p.highlight().color());
    } else {
        p.setColor(QPalette::Foreground, p.text().color());
    }

    ui->messageLabel->setPalette(p);
}

bool NotificationItem::isUnread()
{
    return m_unread;
}

void NotificationItem::setObjectType(QString objectType)
{
    m_objectType = objectType;
}

void NotificationItem::setText(QString message)
{
    ui->messageLabel->setText(message);
}

void NotificationItem::setObjectId(QString id)
{
    m_objectId = id;
}

void NotificationItem::getAvatar()
{
    QString urlString = QString("https://graph.facebook.com/%1/picture?acccess_token=%2").arg(m_userId, accessToken);
    avatarReply = nam->get(QNetworkRequest(urlString));
    if (avatarReply)
        connect(avatarReply, SIGNAL(finished()), this, SLOT(onAvatarReceived()));
}

void NotificationItem::onAvatarReceived()
{
    QUrl redir = avatarReply->attribute(QNetworkRequest::RedirectionTargetAttribute).toUrl();
    if (!redir.isEmpty()) {
        avatarReply->deleteLater();

        QString url = redir.toString();
        int pos = url.lastIndexOf("/");
        QString baseName = url.remove(0, pos);
        baseName.remove("/");

        QFile cachedImage(QDesktopServices::storageLocation(QDesktopServices::CacheLocation) + "/" + baseName);
        if (cachedImage.exists()) {
            cachedImage.open(QIODevice::ReadOnly);
            QByteArray data = cachedImage.readAll();
            cachedImage.close();
            if (ui->avatarLabel->pixmap() == 0) {
                QPropertyAnimation *animation = new QPropertyAnimation(ui->avatarLabel, "pos", this);
                animation->setStartValue(QPoint(ui->avatarLabel->x(), ui->avatarLabel->y()-200));
                animation->setEndValue(ui->avatarLabel->pos());
                animation->setDuration(1000);
                animation->setEasingCurve(QEasingCurve::InOutBack);
                animation->start(QPropertyAnimation::DeleteWhenStopped);
            }
            ui->avatarLabel->setPixmap(QPixmap::fromImage(QImage::fromData(data)));
            return;
        }

        avatarReply = nam->get(QNetworkRequest(redir));
        connect(avatarReply, SIGNAL(finished()), this, SLOT(onAvatarReceived()));

        return;
    }

    QByteArray data = avatarReply->readAll();

    if (ui->avatarLabel->pixmap() == 0) {
        QPropertyAnimation *animation = new QPropertyAnimation(ui->avatarLabel, "pos", this);
        animation->setStartValue(QPoint(ui->avatarLabel->x(), ui->avatarLabel->y()-200));
        animation->setEndValue(ui->avatarLabel->pos());
        animation->setDuration(1000);
        animation->setEasingCurve(QEasingCurve::InOutBack);
        animation->start(QPropertyAnimation::DeleteWhenStopped);
    }
    ui->avatarLabel->setPixmap(QPixmap::fromImage(QImage::fromData(data)));
    avatarReply->deleteLater();

    QString url = avatarReply->url().toString();
    int pos = url.lastIndexOf("/");
    QString baseName = url.remove(0, pos);
    baseName.remove("/");
    QDir tempDir(QDesktopServices::storageLocation(QDesktopServices::CacheLocation));
    if (!tempDir.exists())
        tempDir.mkpath(QDesktopServices::storageLocation(QDesktopServices::CacheLocation));

    QString filename = QDesktopServices::storageLocation(QDesktopServices::CacheLocation) + "/" + baseName;
    QFile cachedImage(filename);
    cachedImage.open(QIODevice::WriteOnly);
    cachedImage.write(data);
    cachedImage.close();
}

QString NotificationItem::objectId()
{
    return m_objectId;
}

QString NotificationItem::objectType()
{
    return m_objectType;
}

QString NotificationItem::userId()
{
    return m_userId;
}

QString NotificationItem::text()
{
    return ui->messageLabel->text();
}

QString NotificationItem::notificationId()
{
    return m_notificationId;
}

bool NotificationItem::isPressed()
{
    return m_pressed;
}

void NotificationItem::mousePressEvent(QMouseEvent *ev)
{
    if (ev->button() == Qt::LeftButton) {
        m_pressed = true;
        emit pressed();
    }
}

void NotificationItem::mouseReleaseEvent(QMouseEvent *ev)
{
    if (ev->button() == Qt::LeftButton) {
        m_pressed = false;
        emit released();
        if (rect().contains(ev->pos())) {
            emit clicked(this);
            this->setUnread(false);
        }
    }
}

void NotificationItem::paintEvent(QPaintEvent *)
{
    /* Not sure if I should add this, makes the widget look like a list, but it looks better without it
       imo, will see about it later */
    /*
    QPainter painter(this);
    QRect rect = this->rect();
    QPoint left = rect.bottomLeft();
    QPoint right = rect.bottomRight();
    painter.setPen(this->palette().highlight().color());
    painter.drawLine(left, right);
    */
}
