#include "notificationsdialog.h"
#include "ui_notificationsdialog.h"
#include "systemnotification.h"

SystemNotification *m_notifier = 0;

NotificationsDialog::NotificationsDialog(QWidget *parent, QString token) :
    QDialog(parent),
    ui(new Ui::NotificationsDialog),
    accessToken(token),
    nam(new QNetworkAccessManager(this)),
    qfacebook(new QFacebook(token, this))
{
    ui->setupUi(this);
    isFetching = false;
    m_notifier = new SystemNotification(this);
    this->orientationChanged();
    this->updateNotifications();
    this->getNoficiationCount();
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
}

NotificationsDialog::~NotificationsDialog()
{
    m_notifier->clearNotifications();
    delete ui;
}

void NotificationsDialog::orientationChanged()
{
#ifdef Q_WS_MAEMO_5
    setMinimumHeight(QApplication::desktop()->screenGeometry().height());
#endif
}

void NotificationsDialog::getNoficiationCount()
{
    QString url = QString("https://api.facebook.com/method/notifications.get?access_token=%1").arg(accessToken);
    countReply = nam->get(QNetworkRequest(url));
    if (countReply)
        connect(countReply, SIGNAL(finished()), this, SLOT(onGotNotificationsCount()));
}

void NotificationsDialog::onGotNotificationsCount()
{
    if (countReply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch notifications!";
        countReply->deleteLater();
        countReply = 0;
        return;
    }

    QXmlStreamReader xml(countReply->readAll());
    while (!xml.atEnd() && !xml.hasError()) {
        QXmlStreamReader::TokenType token = xml.readNext();
        /* If token is just StartDocument, we'll go to next.*/
        if (token == QXmlStreamReader::StartDocument) {
                continue;
        }
        /* If token is StartElement, we'll see if we can read it.*/
        if (token == QXmlStreamReader::StartElement) {
            //if (xml.name() == "notification_counts")

        }
    }
    /* Error handling. */
    if (xml.hasError()) {
        QMessageBox::critical(this,
                              "QXSRExample::parseXML",
                              xml.errorString(),
                              QMessageBox::Ok);
    }
    /* Removes any device() or data from the reader
     * and resets its internal state to the initial state. */
    xml.clear();
}

void NotificationsDialog::updateNotifications()
{
    if (isFetching)
        return;

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif

    reply = qfacebook->getConnections("me", "notifications&include_read=1");
    if (reply) {
        connect(reply, SIGNAL(finished()), this, SLOT(onNotificationsListReceived()));
        isFetching = true;
    }
}

void NotificationsDialog::onNotificationsListReceived()
{
    isFetching = false;

    if (this->reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch notifications!";
        this->reply->deleteLater();
        this->reply = 0;

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif

        return;
    }

    QVariant notificationsVariant = reply->data();
    if (notificationsVariant == m_notifications) {
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
        return;
    } else {
        m_notifications = notificationsVariant;
    }

    if (!notificationItems.isEmpty()) {
        foreach (NotificationItem *item, notificationItems) {
            ui->layout->removeWidget(item);
            notificationItems.removeOne(item);
            delete item;
        }
    }

    m_unreadNotifications.clear();
    m_notifier->clearNotifications();
    unreadCount = 0;

    QVariantList listData = notificationsVariant.toMap().value("data").toList();

    foreach (QVariant jsonData, listData) {
        QString text = jsonData.toMap().value("title").toString();

        // notif_USER-ID-HERE_NOTIFICATION-ID
        // Butcher this to get the last part

        QString notificationIdTmp = jsonData.toMap().value("id").toString();

        int indexOf = notificationIdTmp.lastIndexOf("_");
        QString notificationId = notificationIdTmp.remove(0, indexOf);
        // Just in case...
        notificationId.remove("_");

        // So apparently facebook removes this too, gotta butcher URLs to get it
        // QString objectId = jsonData.toMap().value("object_id").toString();

        // And... it's back, with the Graph API ~November 30, 2012
        QString objectId = jsonData.toMap().value("object").toMap().value("id").toString();
        QString objectType = jsonData.toMap().value("object").toMap().value("type").toString();
        QString senderId = jsonData.toMap().value("object").toMap().value("from").toMap().value("id").toString();
        if (senderId.isEmpty()) {
            senderId = jsonData.toMap().value("from").toMap().value("id").toString();
        }
        QString avatarUrl = "https://graph.facebook.com/" + senderId + "/picture" + "&accessToken=" + accessToken;
        QString link = jsonData.toMap().value("link").toString();
        QString pictureUrl = jsonData.toMap().value("object").toMap().value("picture").toString();
        QString applicationId = jsonData.toMap().value("application").toMap().value("id").toString();
        QString statusType = jsonData.toMap().value("object").toMap().value("status_type").toString();
        bool isUnread = jsonData.toMap().value("unread").toBool();

        if (objectType.isEmpty()) {
            if (link.contains("photo.php")) {
                objectType = "photo";
            } else if (link.contains("pokes")) {
                objectType = "poke";
            } else if (!jsonData.toMap().value("object").toMap().value("place").toMap().isEmpty()) {
                objectType = "status";
            }
        }

        if (objectType == "group" || applicationId == FACEBOOK_APPLICATION_GROUPS_ID) {
            QString href = link;
            href.remove("http://www.facebook.com/groups/");
            if (href.contains("comment_id")) {
                int pos = href.lastIndexOf("/");
                href.remove(pos, href.size()-pos);
            }
            href.replace("/", "_");
            if (href.endsWith("_"))
                href.chop(1);

            objectId = href;
            objectType = "status";
        }

        if (statusType == "shared_story") {
            objectType = "status";
        }

        if (!text.isEmpty()) {
            NotificationItem *item = new NotificationItem(this, accessToken, nam);
            connect(item, SIGNAL(markedAsRead(NotificationItem*)), this, SLOT(onMarkedAsRead(NotificationItem*)));
            connect(item, SIGNAL(clicked(NotificationItem*)), this, SLOT(onNotificationClicked(NotificationItem*)));
            item->setObjectId(objectId);
            item->setObjectType(objectType);
            item->setUserId(senderId);
            item->setText(text);
            item->setNotificationId(notificationId);
            if (isUnread) {
                m_unreadNotifications.append(item);
                m_notifier->createNotification("Facebook", item->text(), "general_facebook");
                m_notifier->vibrate();
                unreadCount++;
            }
            if (unreadCount > 0)
                m_notifier->createSoundNotification();
            item->setUnread(isUnread);
            ui->layout->addWidget(item);
            notificationItems.append(item);
        }
    }
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
    emit gotNotificationsCount(unreadCount);
}

void NotificationsDialog::onNotificationClicked(NotificationItem *item)
{
    item->markAsRead();
    QString type = item->objectType();
    qDebug() << type;
    if (type == "status") {
        SinglePostWindow *post = new SinglePostWindow(this->parentWidget(), accessToken);
        post->loadPost(item->objectId());
#ifdef Q_WS_S60
        post->showMaximized();
#else
        post->show();
#endif
    } else if (type == "group") {
        ProfileWindow *group = new ProfileWindow(this->parentWidget(), accessToken, ProfileWindow::GroupProfile);
        group->browseProfile(item->objectId());
        group->setWindowTitle(tr("Group"));
#ifdef Q_WS_S60
        group->showMaximized();
#else
        group->show();
#endif
    } else if (type == "photo") {
        PhotoWindow *photo = new PhotoWindow(this->parentWidget(), accessToken);
        photo->showPhotoFromId(item->objectId());
        photo->setWindowTitle(tr("Photo"));
#ifdef Q_WS_S60
        photo->showMaximized();
#else
        photo->show();
#endif
    } else if (type == "friend") {
        ProfileWindow *profile = new ProfileWindow(this->parentWidget(), accessToken);
        profile->browseProfile(item->objectId());
        profile->setWindowTitle(tr("Profile"));
#ifdef Q_WS_S60
        profile->showMaximized();
#else
        profile->show();
#endif
    }
}

void NotificationsDialog::markRead()
{
    foreach (NotificationItem *item, m_unreadNotifications) {
        item->markAsRead();
    }
}

void NotificationsDialog::onMarkedAsRead(NotificationItem *item)
{
    m_unreadNotifications.removeOne(item);
    emit gotNotificationsCount(m_unreadNotifications.count());
}

void NotificationsDialog::showEvent(QShowEvent *)
{
    this->updateNotifications();
    m_notifier->clearNotifications();
    // Delay setting as read for a while, gives the user a chance to see which notificaions were unread
    this->markRead();
}
