#ifndef NEWSTATUSUPDATEDIALOG_H
#define NEWSTATUSUPDATEDIALOG_H

#include <QDialog>
#include <QPushButton>
#include <QDebug>
#include <QPointer>
#include <QDesktopWidget>
#ifdef Q_WS_MAEMO_5
    #include <QMaemo5InformationBox>
#else
    #include <QMessageBox>
#endif

#include "qfacebook.h"

namespace Ui {
    class NewStatusUpdateDialog;
}

class NewStatusUpdateDialog : public QDialog
{
    Q_OBJECT

public:
    explicit NewStatusUpdateDialog(QWidget *parent = 0, QFacebook *qfacebook = 0, QString userId = "me");
    ~NewStatusUpdateDialog();

signals:
    void posted(bool success);
    void posted();

private:
    Ui::NewStatusUpdateDialog *ui;
    QFacebook *qfacebook;
    QString m_userId;
    QPointer<QFacebookReply> statusReply;
    void postUpdate(QString text, QString link, QString video);

private slots:
    void accept();
    void onStatusUpdateReplyFinished();
    void orientationChanged();
};

#endif // NEWSTATUSUPDATEDIALOG_H
