#ifndef QCLICKABLELABEL_H
#define QCLICKABLELABEL_H

#include <QLabel>
#include <QMouseEvent>

class QClickableLabel : public QLabel
{
    Q_OBJECT
public:
    explicit QClickableLabel(QWidget *parent = 0);
    bool isPressed();
    QVariant data();

public slots:
    void setData(QVariant data);

protected:
    void mousePressEvent(QMouseEvent *ev);
    void mouseReleaseEvent(QMouseEvent *ev);

signals:
    void pressed();
    void released();
    void clicked();
    void clickedPos(QPoint position);

private:
    bool m_pressed;
    QVariant variant;
};

#endif // QCLICKABLELABEL_H
