#ifndef LOADINGWIDGET_H
#define LOADINGWIDGET_H

#include <QWidget>
#include <QTimeLine>
#include <QDebug>
#include <QPropertyAnimation>
#include <QHideEvent>
#include <QSettings>

namespace Ui {
    class LoadingWidget;
}

class LoadingWidget : public QWidget
{
    Q_OBJECT

public:
    explicit LoadingWidget(QWidget *parent = 0);
    ~LoadingWidget();

public slots:
    void hideWidget();
    void setLoading(bool isLoading);

protected:
    void showEvent(QShowEvent *);

private:
    Ui::LoadingWidget *ui;
    QTimeLine *timeline;
    QPixmap m_pixmap;
    QPoint m_shownPos;
    QPoint m_hiddenPos;
    bool m_isLoading;
    QSize m_parentSize;

private slots:
    void onFrameChanged(int frame);
};

#endif // LOADINGWIDGET_H
