#include "newstatusupdatedialog.h"
#include "ui_newstatusupdatedialog.h"

NewStatusUpdateDialog::NewStatusUpdateDialog(QWidget *parent, QFacebook *qfacebook, QString userId) :
    QDialog(parent),
    ui(new Ui::NewStatusUpdateDialog),
    qfacebook(qfacebook),
    m_userId(userId)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);
    ui->videoEdit->hide();
    ui->linkEdit->hide();
    QPushButton *addLink = new QPushButton(tr("Attach link"), this);
    QPushButton *addVideo = new QPushButton(tr("Attach video"), this);
    connect(addLink, SIGNAL(clicked()), ui->linkEdit, SLOT(show()));
    connect(addVideo, SIGNAL(clicked()), ui->videoEdit, SLOT(show()));
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
    ui->buttonBox->addButton(addLink, QDialogButtonBox::ActionRole);
    ui->buttonBox->addButton(addVideo, QDialogButtonBox::ActionRole);
    this->orientationChanged();
}

NewStatusUpdateDialog::~NewStatusUpdateDialog()
{
    delete ui;
}

void NewStatusUpdateDialog::accept()
{
    ui->textEdit->setEnabled(false);
    ui->buttonBox->setEnabled(false);
    ui->linkEdit->setEnabled(false);
    ui->videoEdit->setEnabled(false);
    this->hide();
    postUpdate(ui->textEdit->toPlainText(), ui->linkEdit->text(), ui->videoEdit->text());
}

void NewStatusUpdateDialog::postUpdate(QString text, QString link, QString video)
{
    QByteArray data;
    text = text.replace("&", "&amp;");
    link = link.replace("&", "&amp;");
    video = video.replace("&", "&amp;");
    if (!text.isEmpty()) {
        data.append("message=" + text.toUtf8());
        if (!link.isEmpty() || !video.isEmpty())
            data.append("&");
    }
    if (!link.isEmpty()) {
        data.append("link=" + link);
        if (!video.isEmpty())
            data.append("&");
    }
    if (!video.isEmpty())
        data.append("video=" + video);

    statusReply = qfacebook->putObject(m_userId, "feed", data);
    if (statusReply)
        connect(statusReply, SIGNAL(finished()), this, SLOT(onStatusUpdateReplyFinished()));
}

void NewStatusUpdateDialog::onStatusUpdateReplyFinished()
{
    ui->textEdit->setEnabled(true);
    ui->buttonBox->setEnabled(true);
    ui->linkEdit->setEnabled(true);
    ui->videoEdit->setEnabled(true);

    QString title = tr("Success");
    QString message;
    if (m_userId == "me")
        message = tr("Status update posted");
    else
        message = tr("Post successful");

    bool error = false;
    if (statusReply->error() != QNetworkReply::NoError) {
        title = tr("Post failed");

        if (m_userId == "me")
            message = tr("Unable to post status update");
        else
            message = tr("Unable to post status update");

        message.append(statusReply->data().toString());
        qDebug() << message;
        error = true;
    }

    emit posted(!error);
    if (!error)
        emit posted();

#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information(this->parentWidget(), message);
#else
    QMessageBox::information(this->parentWidget(), title, message);
#endif

    statusReply->deleteLater();
    if (!error)
        this->close();
    else
        this->show();
}

void NewStatusUpdateDialog::orientationChanged()
{
#ifdef Q_WS_MAEMO_5
    ui->mainLayout->removeWidget(ui->buttonBox);
    if (QApplication::desktop()->screenGeometry().width() > QApplication::desktop()->screenGeometry().height()) {
        ui->buttonBox->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Minimum));
        ui->mainLayout->addWidget(ui->buttonBox, 0, 1, 1, 1);
        this->setMinimumHeight(300);
        this->setMaximumHeight(300);
    } else {
        ui->buttonBox->setSizePolicy(QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Minimum));
        ui->mainLayout->addWidget(ui->buttonBox, 1, 0, 1, ui->mainLayout->columnCount(), Qt::AlignBottom);
        this->setMaximumHeight(600);
        this->setMinimumHeight(600);
    }
#endif
}
