#ifndef PLACESWINDOW_H
#define PLACESWINDOW_H

#include <QMainWindow>
#ifdef MOBILITY
    #include <QGeoPositionInfo>
    #include <QGeoPositionInfoSource>
#endif
#include <QDebug>
#include <qfacebook.h>

#include "widgets/placeitem.h"
#include "checkindialog.h"
#include "checkinwindow.h"

#ifdef MOBILITY
    QTM_USE_NAMESPACE
#endif
namespace Ui {
    class PlacesWindow;
}

class PlacesWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit PlacesWindow(QWidget *parent = 0, QString token = "0");
    ~PlacesWindow();

signals:
    void coordinatesChanged(double, double);

protected:
    void closeEvent(QCloseEvent *);

private:
    Ui::PlacesWindow *ui;
    QString accessToken;
#ifdef MOBILITY
    QGeoPositionInfoSource *source;
#endif
    QFacebook *qfacebook;
    QFacebookReply *reply;
    double longitude;
    double latitude;
    QList<PlaceItem*> checkins;
    QNetworkAccessManager *nam;

private slots:
#ifdef MOBILITY
    void onPositionUpdated(QGeoPositionInfo info);
#endif
    void onSearchReplyReceived();
    void updateRecentCheckins();
    void checkIn();
    void onPlaceSelected(QString name, QString id, QString longitude, QString latitude);
    void onNameClicked(QString id, QString name);
};

#endif // PLACESWINDOW_H
