#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QTimer>
#include <QSettings>
#include <QListWidgetItem>
#include <QNetworkReply>
#include <QNetworkAccessManager>
#include <QMenu>
#include <QCloseEvent>
#include <QPointer>
#include <QNetworkConfigurationManager>
#ifdef Q_WS_MAEMO_5
    #include <QDBusInterface>
    #define DBUS_SERVICE   "org.maemo.sociality"
    #define DBUS_PATH      "/org/maemo/sociality"
    #define DBUS_INTERFACE "org.maemo.sociality"
#endif
#include "loginwindow.h"
#include "friendswindow.h"
#include "newsfeedwindow.h"
#include "messageswindow.h"
#include "albumswindow.h"
#include "notificationsdialog.h"
#include "groupswindow.h"
#include "eventswindow.h"
#include "placeswindow.h"
#include "noteswindow.h"
#include "aboutdialog.h"
#include "chatwindow.h"
#include "settingsdialog.h"
#include "facebookbrowser.h"
#include <qjson/parser.h>

#include "delegates/thumbnailitemdelegate.h"

namespace Ui {
    class MainWindow;
}

typedef struct
{
    QString text;
    QIcon avatar;
    QString userId;
} FavoriteItem;

QDataStream &operator<<(const QDataStream &out, const FavoriteItem &item);
QDataStream &operator>>(const QDataStream &in, FavoriteItem &item);
bool operator==(const FavoriteItem &item1, const FavoriteItem &item2);

class MainWindow : public QMainWindow
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.maemo.sociality")

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

public slots:
    Q_SCRIPTABLE void top_application();
    Q_SCRIPTABLE void refreshAll();
    Q_SCRIPTABLE void quit();

protected:
    void closeEvent(QCloseEvent *);

signals:
    void refresh();

private:
    Ui::MainWindow *ui;
    void connectSignals();
    QString accessToken;
    QString myId;
    QString myName;
    QFacebook *qfacebook;
    QFacebookReply *reply;
    QPointer<NewsFeedWindow> newsFeedWindow;
    QPointer<FriendsWindow> friendsWindow;
    QPointer<AlbumsWindow> albumsWindow;
    QPointer<ProfileWindow> profileWindow;
    QPointer<MessagesWindow> messagesWindow;
    QPointer<GroupsWindow> groupsWindow;
    QPointer<LoginWindow> loginWindow;
    QPointer<EventsWindow> eventsWindow;
    QPointer<ChatWindow> chatWindow;
    QPointer<NotesWindow> notesWindow;
    QPointer<NotificationsDialog> notificationsDialog;
    QPointer<QNetworkAccessManager> nam;
    QNetworkReply *requestsReply;
    QTimer *m_refreshTimer;
    QList<FavoriteItem>favorites;
    bool isQuitting;
    void getMyId();
    int defaultItemCount;

private slots:
    void createLoginWindow();
    void logout();
    void deleteWindows();
    void onLoggedIn(QString token);
    void onItemActivated(QListWidgetItem *item);
    void orientationChanged();
    void onGetMyIdReply();
    void onContextMenuRequested(QPoint point);
    void onFavoriteDeleteRequested();
    void onGotNotificationCount(int count);
    void showAbout();
    void onAddToFavoritesClicked();
    void onFriendSelected(QList<QListWidgetItem*>);
    void saveFavorites();
    void loadFavorites();
    void onAvatarProcessed(QString id, QImage image);
    void showSettings();
    void openAccountSettings();
    void openPrivacySettings();
    void openHelpCenter();
    void onChatLoginCanceled();
    void getNotifications();
    void onGotNotifications();

#ifdef Q_WS_MAEMO_5
    void takeScreenshot();
    void onHildonLaunch(const QDBusMessage &);
#endif
};

#endif // MAINWINDOW_H
