#include "imageuploaddialog.h"
#include "ui_imageuploaddialog.h"

ImageUploadDialog::ImageUploadDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::ImageUploadDialog)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);
    connect(this, SIGNAL(addImage(QString)), this, SLOT(onImageReceived(QString)));
    connect(ui->photoList, SIGNAL(itemActivated(QListWidgetItem*)), this, SLOT(onPhotoClicked(QListWidgetItem*)));
    QPushButton *localFileButton = new QPushButton(tr("Local file"), this);
    connect(localFileButton, SIGNAL(clicked()), this, SLOT(onLocalFileButtonClicked()));
    QPushButton *cameraButton = new QPushButton(tr("Camera"), this);
    connect(cameraButton, SIGNAL(clicked()), this, SLOT(onCameraButtonClicked()));
    ui->buttonBox->addButton(localFileButton, QDialogButtonBox::ActionRole);
    ui->buttonBox->addButton(cameraButton, QDialogButtonBox::ActionRole);
}

ImageUploadDialog::~ImageUploadDialog()
{
    delete ui;
}

void ImageUploadDialog::onLocalFileButtonClicked()
{
    QString imageUrl = QFileDialog::getOpenFileName(this,
                                                    tr("Select a photo"),
#ifdef Q_WS_MAEMO_5
                                                    "/home/user/MyDocs/DCIM/"
#else
                                                    QDir::homePath(),
#endif
                                                    "Image Files (*.png *.jpg *.bmp)");
    emit addImage(imageUrl);
}

void ImageUploadDialog::onCameraButtonClicked()
{

}

void ImageUploadDialog::onImageReceived(QString filename)
{
    m_files.append(filename);
    QListWidgetItem *item = new QListWidgetItem(ui->photoList);
    item->setIcon(QIcon(QPixmap(filename)));
    item->setData(Qt::UserRole, filename);
}

void ImageUploadDialog::onPhotoClicked(QListWidgetItem *item)
{
    PhotoWindow *photo = new PhotoWindow(this);
    photo->setPhoto(item->data(Qt::UserRole).toString());
    photo->show();
}

void ImageUploadDialog::accept()
{
    emit uploadImages(m_files);
    this->close();
}
