#include "groupswindow.h"
#include "ui_groupswindow.h"

GroupsWindow::GroupsWindow(QWidget *parent, QString token) :
    QMainWindow(parent),
    ui(new Ui::GroupsWindow),
    accessToken(token),
    qfacebook(new QFacebook(token, this)),
    nam(new QNetworkAccessManager(this))
{
    ui->setupUi(this);
    connect(ui->groupsList, SIGNAL(itemActivated(QListWidgetItem*)), this, SLOT(onGroupClicked(QListWidgetItem*)));
    connect(ui->actionRefresh, SIGNAL(triggered()), this, SLOT(updateGroups()));
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
}

GroupsWindow::~GroupsWindow()
{
    delete ui;
}

void GroupsWindow::browseGroups(QString userId)
{
    m_userId = userId;
    this->updateGroups();
}

void GroupsWindow::onGroupClicked(QListWidgetItem *item)
{
    ProfileWindow *group = new ProfileWindow(this, accessToken);
    group->setWindowTitle(item->text());
    group->browseProfile(item->data(Qt::UserRole).toString());
#ifdef Q_WS_S60
    group->showMaximized();
#else
    group->show();
#endif
}

void GroupsWindow::updateGroups()
{
    reply = qfacebook->getConnections(m_userId, "groups");
    if (reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
}

void GroupsWindow::onReplyReceived()
{
    if (reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to group list!";
        reply->deleteLater();
        reply = 0;

        return;
    }

    ui->groupsList->clear();

    QVariant jsonData = reply->data();
    QVariantList listData;
    listData = jsonData.toMap().value("data").toList();
    foreach (QVariant jsonData, listData) {
        QString version = jsonData.toMap().value("version").toString();
        if (version == "1") {
            QString name = jsonData.toMap().value("name").toString();
            QString id = jsonData.toMap().value("id").toString();

            QListWidgetItem *item = new QListWidgetItem(ui->groupsList);
            item->setText(name);
            item->setData(Qt::UserRole, id);

            Group *group = new Group(this, id);
            QString avatarUrl = QString("https://graph.facebook.com/%1/picture&access_token=%2").arg(id, accessToken);
            QNetworkReply *reply =
                    nam->get(QNetworkRequest(avatarUrl));
            connect(reply, SIGNAL(finished()), group, SLOT(avatarReceived()));
            connect(group, SIGNAL(avatarProcessed(QString,QPixmap)), this, SLOT(onAvatarProcessed(QString,QPixmap)));
        }
    }
}

void GroupsWindow::onAvatarProcessed(QString id, QPixmap pixmap)
{
    for (int i = 0; i < ui->groupsList->count(); i++) {
        if (ui->groupsList->item(i)->data(Qt::UserRole).toString() == id)
            ui->groupsList->item(i)->setIcon(QIcon(pixmap));
    }
}

Group::Group (QWidget *parent, QString id) :
    groupId(id)
{
    this->setParent(parent);
}

Group::~Group() {}

void Group::avatarReceived()
{
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(sender());
    QUrl redir = reply->attribute(QNetworkRequest::RedirectionTargetAttribute).toUrl();
    if (!redir.isEmpty()) {
        reply->deleteLater();
        QNetworkAccessManager *nam = qobject_cast<QNetworkAccessManager*>(sender()->parent());
        QNetworkReply *reply = nam->get(QNetworkRequest(redir));

        connect(reply, SIGNAL(finished()), this, SLOT(avatarReceived()));
        return;
    }
    emit avatarProcessed(this->groupId, QPixmap::fromImage(QImage::fromData(reply->readAll())));
    reply->deleteLater();
    this->deleteLater();
}
