#ifndef NEWEVENTDIALOG_H
#define NEWEVENTDIALOG_H

#include <QDialog>
#ifdef Q_WS_MAEMO_5
    #include <QMaemo5InformationBox>
#else
    #include <QMessageBox>
#endif
#include <QDebug>
#include <qfacebook.h>

namespace Ui {
    class NewEventDialog;
}

class NewEventDialog : public QDialog
{
    Q_OBJECT

public:
    explicit NewEventDialog(QWidget *parent = 0, QString token = "0", QFacebook *qfacebook = 0);
    ~NewEventDialog();

signals:
    void eventCreated();

private:
    Ui::NewEventDialog *ui;
    QString accessToken;
    QFacebook *qfacebook;
    QFacebookReply *reply;

private slots:
    void accept();
    void onReplyReceived();

};

#endif // NEWEVENTDIALOG_H
