#ifndef FACEBOOKBROWSER_H
#define FACEBOOKBROWSER_H

#include <QMainWindow>
#include <QDir>
#include <QDesktopServices>
#include <QPropertyAnimation>
#include <QWebPage>
#include <QWebView>
#include "cookiejar.h"
#ifdef Q_WS_MAEMO_5
    #include "qwebviewselectionsuppressor.h"
#endif

namespace Ui {
    class FacebookBrowser;
}

class FacebookBrowser : public QMainWindow
{
    Q_OBJECT

public:
    explicit FacebookBrowser(QWidget *parent = 0);
    ~FacebookBrowser();
    enum FacebookPages {FacebookAccountSettings,
                        FacebookPrivacySettings,
                        FacebookHelpCenter};
    void openPage(FacebookBrowser::FacebookPages page);

private:
    Ui::FacebookBrowser *ui;

private slots:
    void onLoadStarted();
    void onLoadFinished(bool);
};

class WebPage : public QWebPage
{
public:
    WebPage(QWebView *parent = 0);
    QString userAgentForUrl(const QUrl &url) const;
};

#endif // FACEBOOKBROWSER_H
