#ifndef COOKIEJAR_H
#define COOKIEJAR_H

#include <QObject>
#include <QNetworkCookieJar>
#include <QList>
#include <QNetworkCookie>
#include <QFile>
#include <QTextStream>
#include <QDebug>

class CookieJar : public QNetworkCookieJar
{
    Q_OBJECT

public:
    CookieJar(QString path, QObject *parent = 0);
    ~CookieJar();
    QList<QNetworkCookie> cookiesForUrl( const QUrl & url) const;
    bool setCookiesFromUrl(const QList<QNetworkCookie> & cookieList, const QUrl & url);

private:
    QString m_filename;
};

#endif // COOKIEJAR_H
