#include "placeswindow.h"
#include "ui_placeswindow.h"

PlacesWindow::PlacesWindow(QWidget *parent, QString token) :
    QMainWindow(parent),
    ui(new Ui::PlacesWindow),
    accessToken(token),
#ifdef MOBILITY
    source(QGeoPositionInfoSource::createDefaultSource(this)),
#endif
    qfacebook(new QFacebook(token, this)),
    nam(new QNetworkAccessManager(this))
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    setAttribute(Qt::WA_DeleteOnClose);
#ifdef MOBILITY
    if (source) {
        source->setPreferredPositioningMethods(QGeoPositionInfoSource::SatellitePositioningMethods);
        source->setUpdateInterval(10000);
        connect(source, SIGNAL(positionUpdated(QGeoPositionInfo)), this, SLOT(onPositionUpdated(QGeoPositionInfo)));
        source->startUpdates();
    }
#endif
    this->updateRecentCheckins();
    connect(ui->actionCheck_in, SIGNAL(triggered()), this, SLOT(checkIn()));
}

PlacesWindow::~PlacesWindow()
{
    delete ui;
}

void PlacesWindow::updateRecentCheckins()
{
    reply = qfacebook->getObject(QString("search&type=checkin&access_token=%1").arg(accessToken));
    if (reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onSearchReplyReceived()));
}

#ifdef MOBILITY
void PlacesWindow::onPositionUpdated(QGeoPositionInfo info)
{
    QGeoCoordinate coordinates = info.coordinate();
    longitude = coordinates.longitude();
    latitude = coordinates.latitude();
    emit coordinatesChanged(longitude, latitude);
}
#endif

void PlacesWindow::onSearchReplyReceived()
{
    if (this->reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch news feed!";
        this->reply->deleteLater();
        this->reply = 0;

        return;
    }

    foreach (PlaceItem *item, checkins) {
        ui->scrollLayout->removeWidget(item);
        checkins.removeOne(item);
        delete item;
    }

    QVariant jsonData = this->reply->data();
    QVariantList listData = jsonData.toMap().value("data").toList();
    foreach (jsonData, listData) {
        // From
        QString fromName = jsonData.toMap().value("from").toMap().value("name").toString();
        QString userId = jsonData.toMap().value("from").toMap().value("id").toString();
        QString checkinId = jsonData.toMap().value("id").toString();
        QDateTime timeDate = QDateTime::fromString(jsonData.toMap().value("created_time").toString(), Qt::ISODate);
        QString time = QString(timeDate.toString("dddd, MMMM d %1 hh:mmap").arg(tr("at")));

        // Place
        QString placeName = jsonData.toMap().value("place").toMap().value("name").toString();
        QString placeId = jsonData.toMap().value("place").toMap().value("id").toString();

        // place/location
        QString streetName = jsonData.toMap().value("place").toMap().value("location").toMap().value("street").toString();
        QString cityName = jsonData.toMap().value("place").toMap().value("location").toMap().value("city").toString();
        QString countryName = jsonData.toMap().value("place").toMap().value("location").toMap().value("country").toString();
        int zipCode = jsonData.toMap().value("place").toMap().value("location").toMap().value("zip").toInt();
        double longitude = jsonData.toMap().value("place").toMap().value("location").toMap().value("longitude").toDouble();
        double latitude = jsonData.toMap().value("place").toMap().value("location").toMap().value("latitude").toDouble();
        Q_UNUSED(zipCode)

        PlaceItem *item = new PlaceItem(this, accessToken, nam);
        item->setName(fromName);
        item->setUserId(userId);
        item->setCheckinId(checkinId);
        item->setTime(time);
        item->setLocation(placeName);
        item->setPlaceId(placeId);
        item->setCoordinates(longitude, latitude);
        item->setAvatarUrl(QString("https://graph.facebook.com/%1/picture&access_token=%2").arg(userId, accessToken));
        ui->scrollLayout->addWidget(item);
        checkins.append(item);
    }
}

void PlacesWindow::checkIn()
{
    CheckinDialog *dialog = new CheckinDialog(this, accessToken);
    connect(this, SIGNAL(coordinatesChanged(double,double)), dialog, SLOT(setCoordinates(double,double)));
    connect(dialog, SIGNAL(placeSelected(QString,QString,QString,QString)),
            this, SLOT(onPlaceSelected(QString,QString,QString,QString)));
    dialog->setCoordinates(longitude, latitude);
    dialog->show();
}

void PlacesWindow::onPlaceSelected(QString name, QString id, QString longitude, QString latitude)
{
    qDebug() << name << id << longitude << latitude;
    CheckinWindow *checkInWindow = new CheckinWindow(this, accessToken);
    checkInWindow->setLocation(name, id, longitude, latitude);
    checkInWindow->show();
}

void PlacesWindow::closeEvent(QCloseEvent *)
{
#ifdef MOBILITY
    if (source)
        source->stopUpdates();
#endif
}
