#ifndef NEWSFEEDWINDOW_H
#define NEWSFEEDWINDOW_H

#include <QMainWindow>
#include <QDebug>
#include <QDesktopWidget>
#include <QNetworkAccessManager>
#include <QSettings>
#include <QScrollBar>
#ifndef Q_WS_MAEMO_5
    #include <QMessageBox>
#endif
#include "newstatusupdatedialog.h"
#include "singlepostwindow.h"
#include "newsfeedpost.h"
#include "profilewindow.h"
#include "qfacebook.h"

namespace Ui {
    class NewsFeedWindow;
}

class NewsFeedWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit NewsFeedWindow(QWidget *parent = 0, QString token = "0");
    ~NewsFeedWindow();

private:
    Ui::NewsFeedWindow *ui;
    QString accessToken;
    QFacebook *qfacebook;
    QFacebookReply *reply;
    QFacebookReply *statusReply;
    QNetworkAccessManager *nam;
    QList<NewsFeedPost*> posts;
    QString myId;
    QString myName;

private slots:
    void onNewStatusUpdateButtonClicked();
    void postUpdate(QString, QString, QString);
    void updateNewsFeed();
    void onReplyFinished();
    void orientationChanged();
    void onCommentButtonClicked(QString, QString, QString);
    void onNameClicked(QString, QString);
    void onStatusUpdateReplyFinished();
};

#endif // NEWSFEEDWINDOW_H
