#ifndef CHECKINWINDOW_H
#define CHECKINWINDOW_H

#include <QMainWindow>
#include <QVariantMap>
#include "friendswindow.h"
#include <qjson/serializer.h>
#include <qjson/qobjecthelper.h>
#include <qfacebook.h>

namespace Ui {
    class CheckinWindow;
}

class CheckinWindow : public QMainWindow
{
    Q_OBJECT

enum LocationRoles {LocationRoleLatitude,
                    LocationRoleLongitude};

public:
    explicit CheckinWindow(QWidget *parent = 0, QString token = "0");
    ~CheckinWindow();

public slots:
    void setLocation(QString name, QString id, QString longitude, QString latitude);

private:
    Ui::CheckinWindow *ui;
    QString accessToken;
    QFacebook *qfacebook;
    QFacebookReply *reply;
    QString m_placeId;
    QStringList friendNames;
    QStringList friendIds;
    QString m_longitude;
    QString m_latitude;

private slots:
    void onRecepientsSelected(QList<QListWidgetItem*>);
    void onTagFriendsClicked();
    void onCheckinButtonClicked();
    void onCheckInReplyReceived();
};

class Place : public QObject
{
  Q_OBJECT

  Q_PROPERTY(QString longitude READ longitude WRITE setLongitude)
  Q_PROPERTY(QString latitude READ latitude WRITE setLatitude)

public:
    Place(QObject* parent = 0);
    ~Place();

    QString longitude() const;
    void setLongitude(const QString& longitude);

    QString latitude() const;
    void setLatitude(const QString& latitude);

  private:
    QString m_longitude;
    QString m_latitude;
};

#endif // CHECKINWINDOW_H
