#include "albumswindow.h"
#include "ui_albumswindow.h"

AlbumsWindow::AlbumsWindow(QWidget *parent, QString token) :
    QMainWindow(parent),
    ui(new Ui::AlbumsWindow),
    qfacebook(new QFacebook(token, this)),
    nam(new QNetworkAccessManager(this)),
    accessToken(token)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    connect(ui->actionRefresh, SIGNAL(triggered()), this, SLOT(updateAlbums()));
    connect(ui->actionNew_album, SIGNAL(triggered()), this, SLOT(onNewAlbumClicked()));
    connect(ui->albumList, SIGNAL(itemActivated(QListWidgetItem*)), this, SLOT(onAlbumClicked(QListWidgetItem*)));
}

AlbumsWindow::~AlbumsWindow()
{
    delete ui;
}

void AlbumsWindow::browseAlbums(QString userId)
{
    m_userId = userId;
    this->updateAlbums();
}

void AlbumsWindow::updateAlbums()
{
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
    this->reply = qfacebook->getConnections(m_userId, "albums&fields=name,id,cover_photo,count");
    if (this->reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
}

void AlbumsWindow::onReplyReceived()
{
    ui->albumList->clear();

    if (this->reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch album list!";
        this->reply->deleteLater();
        this->reply = 0;
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif

        return;
    }

    QVariant jsonData = this->reply->data();
    QVariantList listData;
    listData = jsonData.toMap().value("data").toList();
    foreach(jsonData, listData) {
        QListWidgetItem *item = new QListWidgetItem();
        item->setData(Qt::UserRole, jsonData.toMap().value("id").toString());
        item->setData(AlbumCount, jsonData.toMap().value("count").toString());
        item->setText(jsonData.toMap().value("name").toString());
        AlbumItem *albumItem = new AlbumItem(this, jsonData.toMap().value("id").toString());
        connect(albumItem, SIGNAL(coverImageProcessed(QString,QPixmap)), this, SLOT(onCoverImageProcessed(QString,QPixmap)));
        QString coverImage =
                QString("https://graph.facebook.com/%1/picture&access_token=%2").arg(jsonData.toMap().value("cover_photo").toString(),
                                                                       accessToken);
        QNetworkReply *reply =
                nam->get(QNetworkRequest(coverImage));
        connect(reply, SIGNAL(finished()), albumItem, SLOT(coverReceived()));
        ui->albumList->addItem(item);
    }

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif

    reply->deleteLater();
}

void AlbumsWindow::onNewAlbumClicked()
{
    NewAlbumDialog *dialog = new NewAlbumDialog(this);
    connect(dialog, SIGNAL(createAlbum(QString,QString,QString)), this, SLOT(createAlbum(QString,QString,QString)));
    dialog->show();
}

void AlbumsWindow::createAlbum(QString albumName, QString albumDescription, QString location)
{
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
    QByteArray data;
    data.append("name=" + albumName.toUtf8());
    if (!albumDescription.isEmpty())
        data.append("&message=" + albumDescription.toUtf8());
    if (!location.isEmpty())
        data.append("&location=" + location.toUtf8());
    this->albumCreationReply = qfacebook->putObject("me", "albums", data);
    if (this->albumCreationReply)
        connect(albumCreationReply, SIGNAL(finished()), SLOT(onAlbumCreationReply()));
}

void AlbumsWindow::onAlbumCreationReply()
{
    if (this->albumCreationReply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to create album!";
        this->albumCreationReply->deleteLater();
        this->albumCreationReply = 0;

        return;
    }

#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information(this, tr("Album successfully created"));
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#else
    QMessageBox::information(this, "Album created", tr("Album successfully created"));
#endif

    this->updateAlbums();
}

void AlbumsWindow::onCoverImageProcessed(QString id, QPixmap pixmap)
{
    for (int i = 0; i < ui->albumList->count(); i++) {
        if (ui->albumList->item(i)->data(Qt::UserRole).toString() == id)
            ui->albumList->item(i)->setIcon(QIcon(pixmap));
    }
}

void AlbumsWindow::onAlbumClicked(QListWidgetItem *item)
{
    /* TODO: return if album count is 0 */
    AlbumWindow *window = new AlbumWindow(this, accessToken);
    window->browseAlbum(item->data(Qt::UserRole).toString(), item->data(AlbumCount).toString());
    window->setWindowTitle(item->text());
#ifdef Q_WS_S60
    window->showMaximized();
#else
    window->show();
#endif
}

AlbumItem::AlbumItem(QWidget *parent, QString id) :
    userId(id)
{
    this->setParent(parent);
}

AlbumItem::~AlbumItem() {}

void AlbumItem::coverReceived()
{
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(sender());
    QUrl redir = reply->attribute(QNetworkRequest::RedirectionTargetAttribute).toUrl();
    if (!redir.isEmpty()) {
        reply->deleteLater();
        QNetworkAccessManager *nam = qobject_cast<QNetworkAccessManager*>(sender()->parent());
        QNetworkReply *reply = nam->get(QNetworkRequest(redir));

        connect(reply, SIGNAL(finished()), this, SLOT(coverReceived()));
        return;
    }
    emit coverImageProcessed(this->userId, QPixmap::fromImage(QImage::fromData(reply->readAll())));
    reply->deleteLater();
    this->deleteLater();
}
