#include "profilewindow.h"
#include "ui_profilewindow.h"

ProfileWindow::ProfileWindow(QWidget *parent, QString token) :
    QMainWindow(parent),
    ui(new Ui::ProfileWindow),
    qfacebook(new QFacebook(token, this)),
    accessToken(token),
    nam(new QNetworkAccessManager(this))
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    //connect(ui->writeOnWallEdit, SIGNAL(), this, SLOT(onTextBoxClicked()));
    connect(ui->writeOnWallEdit, SIGNAL(clicked()), this, SLOT(onTextBoxClicked()));
    connect(ui->actionRefresh, SIGNAL(triggered()), this, SLOT(updateProfile()));
    connect(ui->userAvatar, SIGNAL(clicked()), this, SLOT(onAvatarClicked()));
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
    this->orientationChanged();
}

ProfileWindow::~ProfileWindow()
{
    delete ui;
}

void ProfileWindow::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    ui->scrollAreaWidgetContents->setMaximumWidth(screenGeometry.width()-10);
}

void ProfileWindow::browseProfile(QString id)
{
    this->profileId = id;
    if (id == "me")
        ui->menuOptions->removeAction(ui->actionPoke);
    else
        setAttribute(Qt::WA_DeleteOnClose);
    QString url = QString("https://graph.facebook.com/%1/picture&access_token=%2&type=normal").arg(id, accessToken);
    this->avatarReply = nam->get(QNetworkRequest(url));
    connect(avatarReply, SIGNAL(finished()), this, SLOT(onAvatarReceived()));

    this->infoReply = qfacebook->getObject(id);
    if (this->infoReply)
        connect(infoReply, SIGNAL(finished()), this, SLOT(onInfoReplyReceived()));

    this->reply = qfacebook->getConnections(this->profileId, "feed");
    if (this->reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
}

void ProfileWindow::onInfoReplyReceived()
{
    if (this->infoReply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch profile info!";
        this->infoReply->deleteLater();
        this->infoReply = 0;

        return;
    }

    QVariant jsonData = this->infoReply->data();
    QString name = jsonData.toMap().value("name").toString();
    if (!name.isEmpty())
        this->setWindowTitle(name);
    QString birthday = jsonData.toMap().value("birthday").toString();
    QString fromLocation = jsonData.toMap().value("hometown").toMap().value("name").toString();
    QString currentLocation = jsonData.toMap().value("location").toMap().value("name").toString();
    QString relationshipStatus = jsonData.toMap().value("relationship_status").toString();

    if (relationshipStatus.isEmpty())
        ui->relationshipLabel->hide();
    else
        ui->relationshipLabel->setText(relationshipStatus);

    if (fromLocation.isEmpty())
        ui->fromLabel->hide();
    else
        ui->fromLabel->setText(tr("From") + QString(" %1").arg(fromLocation));

    if (currentLocation.isEmpty())
        ui->locationLabel->hide();
    else
        ui->locationLabel->setText(tr("Lives in") + QString(" %1").arg(currentLocation));

    if (birthday.isEmpty())
        ui->birthdateLabel->hide();
    else
        ui->birthdateLabel->setText(tr("Born on") + QString(" %1").arg(birthday));
}

void ProfileWindow::onAvatarClicked()
{
    PhotoWindow *photo = new PhotoWindow(this, accessToken);
    photo->showPhoto(profileId);
    photo->setWindowTitle(this->windowTitle() + " - " + tr("Profile picture"));
    photo->showMaximized();
}

void ProfileWindow::updateProfile()
{
    this->browseProfile(this->profileId);
}

void ProfileWindow::onAvatarReceived()
{
    QUrl redir = this->avatarReply->attribute(QNetworkRequest::RedirectionTargetAttribute).toUrl();
    if (!redir.isEmpty()) {
        this->avatarReply->deleteLater();
        this->avatarReply = nam->get(QNetworkRequest(redir));

        connect(this->avatarReply, SIGNAL(finished()), this, SLOT(onAvatarReceived()));
        return;
    }
    this->setAvatar(QPixmap::fromImage(QImage::fromData(this->avatarReply->readAll())));
    //this->avatarReply->deleteLater();
}

void ProfileWindow::setAvatar(QPixmap avatar)
{
    ui->userAvatar->setIcon(QIcon(avatar));
}

void ProfileWindow::onReplyReceived()
{
    if (!posts.isEmpty()) {
        foreach (NewsFeedPost *post, posts) {
            ui->scrollLayout->removeWidget(post);
            delete post;
        }
        posts.clear();
    }

    if (this->reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch news feed!";
        this->reply->deleteLater();
        this->reply = 0;

        return;
    }
    QString myId = QSettings().value("main/myId").toString();

    QVariant jsonData = this->reply->data();
    QVariantList listData;
    listData = jsonData.toMap().value("data").toList();
    foreach(jsonData, listData) {
        NewsFeedPost *post = new NewsFeedPost(ui->scrollArea, accessToken, qfacebook, nam);
        connect(post, SIGNAL(nameClicked(QString,QString)), this, SLOT(onNameClicked(QString,QString)));
        connect(post, SIGNAL(commentButtonClicked(QString,QString,QString)),
                this, SLOT(onCommentButtonClicked(QString,QString,QString)));
        QString name = jsonData.toMap().value("from").toMap().value("name").toString();
        QString userId = jsonData.toMap().value("from").toMap().value("id").toString();
        if (userId.contains(myId))
            post->setDeletable(true);
        if (this->profileId == "me")
            post->setDeletable(true);
        QString message = jsonData.toMap().value("message").toString();
        QString icon = jsonData.toMap().value("icon").toString();
        QString time = jsonData.toMap().value("created_time").toString();
        QString link = jsonData.toMap().value("link").toString();
        if (!link.isEmpty()) {
            message.append("\nAttached links:\n");
            message.append(link + "\n");
            message.append(jsonData.toMap().value("name").toString() + "\n");
            message.append(jsonData.toMap().value("caption").toString() + "\n");
            message.append(jsonData.toMap().value("description").toString() + "\n");
        }

        // Check if the currently logged in user likes the post
        QVariantList likes = jsonData.toMap().value("likes").toMap().value("data").toList();
        bool meLikesThis = false;
        QString myId = QSettings().value("main/myId").toString();
        foreach (QVariant likeId, likes) {
            QVariantMap map = likeId.value<QVariantMap>();
            QString likerId = map.value("id").toString();
            if (likerId.contains(myId))
                meLikesThis = true;
            else
                meLikesThis = false;
        }

        // Get like and comment count.
        QString likesCount = jsonData.toMap().value("likes").toMap().value("count").toString();
        if (likesCount.isEmpty())
            likesCount = "0";
        QString comments = jsonData.toMap().value("comments").toMap().value("count").toString();
        if (comments.isEmpty())
            comments = "0";

        // Set parsed data
        post->setName(name);
        post->setMessage(message);
        post->setId(jsonData.toMap().value("id").toString());
        post->setUserId(userId);
        post->getPixmapFromUrl(QString("http://graph.facebook.com/%1/picture").arg(userId));
        post->setLikedByMe(meLikesThis);
        post->setNumberOfLikesComments(likesCount, comments);
        post->setIconFromUrl(icon);
        post->setTime(time);
        posts.append(post);
        ui->scrollLayout->addWidget(post);
    }
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void ProfileWindow::onTextBoxClicked()
{
    NewStatusUpdateDialog *dialog = new NewStatusUpdateDialog(this);
    connect(dialog, SIGNAL(postUpdate(QString,QString,QString)), this, SLOT(onPostToWall(QString,QString,QString)));
    dialog->setWindowTitle(tr("Post to wall"));
    dialog->show();
}

void ProfileWindow::onPostToWall(QString text, QString link, QString video)
{
    dataToPost.clear();

    ui->writeOnWallEdit->setEnabled(false);

    if (!text.isEmpty()) {
        dataToPost.append("message=" + text);
        if (!link.isEmpty() || !video.isEmpty())
            dataToPost.append("&");
    }
    if (!link.isEmpty()) {
        dataToPost.append("link=" + link);
        if (!video.isEmpty())
            dataToPost.append("&");
    }
    if (!video.isEmpty())
        dataToPost.append("video=" + video);

    this->postReply = qfacebook->putObject(this->profileId, "feed", dataToPost);
    connect(postReply, SIGNAL(finished()), this, SLOT(onPosted()));
}

void ProfileWindow::onPosted()
{
    if (this->postReply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to post to wall!";
#ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(this, tr("Faled to post to wall"));
#else
        QMessageBox::information(this, tr("Error"), tr("Failed to post to wall"));
#endif
        this->postReply->deleteLater();
        this->postReply = 0;

        return;
    }

    ui->writeOnWallEdit->setEnabled(true);
    this->updateProfile();
}

void ProfileWindow::onNameClicked(QString id, QString name)
{
    if (id == QSettings().value("main/myId").toString() || id == "me" || id == this->profileId)
        return;

    ProfileWindow *profile = new ProfileWindow(this, accessToken);
    profile->browseProfile(id);
    profile->setWindowTitle(name);
#ifdef Q_WS_S60
    profile->showMaximized();
#else
    profile->show();
#endif
}

void ProfileWindow::onCommentButtonClicked(QString id, QString comments, QString likes)
{
    qDebug() << id;
    SinglePostWindow *window = new SinglePostWindow(this, accessToken);
    window->loadPost(id);
    window->setCountLabel(comments, likes);
#ifdef Q_WS_S60
    window->showMaximized();
#else
    window->show();
#endif
}
