#ifndef EVENTSWINDOW_H
#define EVENTSWINDOW_H

#include <QMainWindow>
#include <QListWidgetItem>
#include <QNetworkAccessManager>
#include <QDebug>
#include <QDateTime>
#include <qfacebook.h>

#include "widgets/eventitem.h"
#include "neweventdialog.h"

namespace Ui {
    class EventsWindow;
}

class EventsWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit EventsWindow(QWidget *parent = 0, QString token = "0");
    ~EventsWindow();
    void browseId(QString id);

private:
    Ui::EventsWindow *ui;
    QFacebook *qfacebook;
    QFacebookReply *attendingReply;
    QFacebookReply *maybeReply;
    QFacebookReply *declinedReply;
    QFacebookReply *notrepliedReply;
    QString accessToken;
    QNetworkAccessManager *nam;
    QString m_userId;
    QList<EventItem*> events;

private slots:
    void updateEvents();
    void onReplyReceived();
    void createEvent();
};

#endif // EVENTSWINDOW_H
