#ifndef UTIL_H
#define UTIL_H

#include <QSettings>
#include <QDebug>
#include <QSize>

static const QSize SNAKE_SIZE = QSize(20,20);
static const QSize MOUSE_SIZE = QSize(20,20);

class Util
{
public:

    static int highScore()
    {
        QSettings setting("Kunal","Snake");
        return setting.value("highScore").toInt();
    }

    static void setHighScore( int aNewHighScore )
    {
        QSettings setting("Kunal","Snake");
        setting.setValue("highScore", aNewHighScore);
    }

    static bool useAccelerometer()
    {
        QSettings setting("Kunal","Snake");
        //qDebug() <<"useAccelerometer ::"<< setting.value("useAccelerometer").toBool();
        return setting.value("useAccelerometer").toBool();
    }

    static void setUseAccelerometer( bool aUserAccelerometer )
    {
        QSettings setting("Kunal","Snake");
        //qDebug() <<"useAccelerometer ::"<< aUserAccelerometer;
        setting.setValue("useAccelerometer",aUserAccelerometer);
    }

    static int speed()
    {
        QSettings setting("Kunal","Snake");
        return setting.value("speed").toInt();
    }

    static void setSpeed( int aNewSpeed )
    {
        QSettings setting("Kunal","Snake");
        setting.setValue("speed",aNewSpeed);
    }

    static int key( const QString& aKey )
    {
        QSettings setting("Kunal","Snake");
        //qDebug() << "key:"<< aKey <<"::"<< setting.value( aKey);
        return setting.value(aKey).toInt();
    }

    static void setKey( const QString& aKey, int aKeyCode )
    {
        QSettings setting("Kunal","Snake");
        //qDebug() << "setKey:"<< aKey <<"::"<< aKeyCode;
        setting.setValue(aKey,aKeyCode);
    }

    static int pointForMouse( int aSpeed ) {

        switch( aSpeed ) {
        case 250: //slow
            return 10;
        case 200: //normal
            return 15;
        case 150: //fast
            return 20;
        case 120:
            return 25;
        default:
            return 0;
        }
    }

    static int pointForBonus( int aSpeed ) {
        int point  = pointForMouse( aSpeed );
        if( point != 0 ) {
            return point + 30;
        }
        return point;
    }
};

#endif // UTIL_H
