#include "snake.h"

#include <QDebug>
#include <QMutexLocker>

#include "util.h"

Snake::Snake()
    : mSnakeBrush(Qt::SolidPattern)
{
    mSnakeBrush.setColor( Qt::green );

    QPoint point( 200,140);
    QPoint direction(1,0);

    for( int i = 0 ; i < 3 ; ++i ) {
        Turn *turn = new Turn;
        turn->mLocation = point;
        turn->mDirection = direction;

        mSnake << turn;

        point -= QPoint(20,0);
    }   
}

Snake::~Snake()
{
    foreach( Turn *turn, mSnake ) {
        delete turn;
    }

    mSnake.empty();
}

void Snake::turn( QPoint aDirection )
{    
    Turn *headTurn = mSnake.at(0);

    if( headTurn->mDirection == aDirection ) {
        //qDebug() << "Already moving in that direction";
        return;
    }

    if( (headTurn->mDirection.x() != 0 && aDirection.x() !=  0 )
        || (headTurn->mDirection.y() != 0 && aDirection.y() !=  0 ) ) {
        //qDebug() << "Turning in opposite direction not allowed";
        return;
    }

    Turn *turn = new Turn(*headTurn);
    turn->mDirection = aDirection;

    mTurns << turn;
}

void Snake::move()
{    
    for(int i = 0 ; i < mSnake.count() ; ++i ) {
        Turn *turn = mSnake[i];

        for( int j = 0 ; j < mTurns.count() ; ++j ) {
            Turn* nextTurn = mTurns[j];
            if( turn->mLocation == nextTurn->mLocation ){

                turn->mDirection = nextTurn->mDirection;
                //tail element takes the turn then remove turn
                if( i == mSnake.count() - 1 ) {                    
                    mTurns.removeAt( j );
                    j--;
                }
            }
        }

        if( turn->mDirection.x() != 0 )
            turn->mLocation.setX(  turn->mLocation.x() + 20 * turn->mDirection.x() );

        else if( turn->mDirection.y() != 0 )
            turn->mLocation.setY( turn->mLocation.y() + 20 * turn->mDirection.y() );

        bouceIfNeeded(turn);
    }
}

bool Snake::isColliding( QPoint aMousePosition )
{
    //check if head is colliding with body
    for( int i = 0 ; i < mSnake.count() ; ++i ) {
        if( aMousePosition == mSnake.at(i)->mLocation ) {
            return true;
        }
    }

    return false;
}

bool Snake::isCollidingWithSelf()
{
    Turn *headTurn = mSnake.at(0);

    //check if head is colliding with body
    for( int i = 1 ; i < mSnake.count() ; ++i ) {
        if( headTurn->mLocation == mSnake.at(i)->mLocation ) {
            return true;
        }
    }

    return false;
}

void Snake::increseLength( int aLenthToIncrement )
{
    Turn *tailTurn = mSnake.last();
    QPoint pointToIncrement(0,0);
    if( tailTurn->mDirection.x() == 1 ) {
        pointToIncrement = QPoint(-20,0);
    } else if( tailTurn->mDirection.x() == -1 ) {
        pointToIncrement = QPoint( 20,0);
    } else if( tailTurn->mDirection.y() == 1 ) {
        pointToIncrement = QPoint( 0,-20);
    } else if( tailTurn->mDirection.y() == -1 ) {
        pointToIncrement = QPoint( 0, 20 );
    }

    for( int i = 0 ; i < aLenthToIncrement; ++i ) {
        Turn *turn = new Turn( * mSnake.last() );
        turn->mLocation = turn->mLocation + pointToIncrement;
        mSnake << turn;
    }
}

void Snake::draw( QPainter* aPainter )
{
    aPainter->setBrush( mSnakeBrush );

    foreach( Turn *turn, mSnake ) {
        aPainter->drawEllipse( QRect(turn->mLocation,SNAKE_SIZE ));
    }

}

QPoint Snake::pos() const
{
    return mSnake.at(0)->mLocation;
}

QPoint Snake::direction() const
{
    return mSnake.at(0)->mDirection;
}

bool Snake::bouceIfNeeded( Turn* aTurn)
{
    if( aTurn->mLocation.x() < 0 ) {
        aTurn->mLocation = QPoint( 780, aTurn->mLocation.y() );
        return true;
    } else if( aTurn->mLocation.x() >= 800 ) {
        aTurn->mLocation = QPoint( 0, aTurn->mLocation.y() );
        return true;
    } else if( aTurn->mLocation.y() < 0 ) {
        aTurn->mLocation = QPoint( aTurn->mLocation.x(), 460 );
        return true;
    } else if( aTurn->mLocation.y() >= 480 ) {
        aTurn->mLocation = QPoint( aTurn->mLocation.x(), 0 );
        return true;
    }

    return false;
}
