#ifndef BOARDS_H
#define BOARDS_H

#import "bord.h"

class EmptyBord : public Bord
{
public:
    EmptyBord():Bord()
    {
    }
};

class SimpleBord : public Bord
{
public:
    SimpleBord():Bord()
    {
        for( int y = 80 ; y < 400 ; y+= 300 ) {
            for( int x = 200 ; x < 600 ; x+= 20 ) {
                mWall << QPoint(x,y);
            }
        }

        for( int x = 200 ; x < 700 ; x+= 400 ) {
            for( int y = 180; y < 300 ; y+= 20 ) {
                 mWall << QPoint(x,y);
            }
        }

    }
};

class TwoCBlock: public Bord
{
public:

    TwoCBlock():Bord()
    {
        for( int x = 100; x < 800 ; x += 580 ) {
            for( int y = 80 ; y < 340 ; y+= 20 ) {
                mWall << QPoint(x,y);
            }
        }

        for( int x = 100 ; x < 700 ; x+= 20 ) {
            mWall << QPoint(x,80);
        }

        for( int x = 240; x < 700 ; x += 300 ) {
            for( int y = 200 ; y < 380 ; y+= 20 ) {
                mWall << QPoint(x,y);
            }
        }

        for( int x = 240 ; x < 560 ; x+= 20 ) {
            mWall << QPoint(x,380);
        }
    }
};

class BoardFactory
{
public:

    static Bord* createRandomBord()
    {
        int bordId = qrand()%3;
        return createBord( bordId );
    }

    static Bord* createBord( int aBordId )
    {
        switch( aBordId ) {
        case O: //empty bord
            return new EmptyBord;
        case 1: //simple board
            return new SimpleBord;
        case 2: //two C board
            return new TwoCBlock;
        }
    }
};


#endif // BOARDS_H
