
#ifndef _GLOBAL_H
#define _GLOBAL_H

#define FILEBUFSIZE 1024

//----------------------------------------------------------------
// this file contains stuff that's needed by every part of smw
//----------------------------------------------------------------

#define TITLESTRING "Super Mario War"
#define VERSIONNUMBER "1.7"

#include <stdlib.h>	//srand/rand (maybe replace with an own version)
#include <string.h>
#include <string>
#include <map>
#include <vector>
#include <list>

#include "sfx.h"
#include "gfx.h"
//#include "net.h"
#include "path.h"

#ifdef LINUXFUNC
	#include "linfunc.h"
#endif

struct STextAward
{
	char			*name;
	gfxFont			*font;
	
	STextAward(char *nname, gfxFont *nfont) {name = nname; font = nfont;}
};

//------------- global definitions -------------


//----------------------------------------------------------------
// DON'T CHANGE THE ORDER xxx_R xxx_L xxx_R xxx_L !!!
//----------------------------------------------------------------
// because this is used to determine the direction the player was facing in the last frame
// if the last sprite was facing right (spr & 0x1) is 0
// because the last bit of every PGFX_[action]_R is 0
// the last bit of PGFX_[action]_L is 1
// IF YOU CHANGE THE ORDER OF THE PGFX_L/R STUFF THIS WON'T WORK!

// see CPlayer::draw() on how this is used

#define PGFX_STANDING_R	0
#define PGFX_STANDING_L	1
#define PGFX_RUNNING_R	2
#define PGFX_RUNNING_L	3
#define PGFX_JUMPING_R	4
#define PGFX_JUMPING_L	5
#define PGFX_STOPPING_R	6
#define PGFX_STOPPING_L	7
#define PGFX_DEADFLYING	8
#define PGFX_DEAD		9
//--------------------------
#define PGFX_LAST		10

#define PANNOUNCER_SOUND_LAST	12
#define PAWARD_LAST		9

#define PH				25		//Player height
#define PW				22		//Player width
#define HALFPH			12
#define HALFPW			11
#define PHOFFSET		4
#define PWOFFSET		5

#define VELMOVING		4.0f		//velocity (speed) for moving left, right
#define VELSLOWMOVING	2.2f		//velocity when slow down powerup is in effect
#define	VELMOVING_CHICKEN 2.9f		//speed of the chicken in the gamemode capturethechicken
#define VELMOVINGADD	0.5f
#define VELMOVINGADDICE VELMOVINGADD / 4
#define VELTURBOMOVING	5.5f
#define VELJUMP			9.0f		//velocity for jumping
#define VELSLOWJUMP		7.0f		//velocity for jumping when slow down powerup is in effect
#define VELTURBOJUMP	10.2f		//velocity for turbo jumping
#define VELPUSHBACK		5.0f
#define VELMAXBREAKBLOCK 3.0f
#define VELNOTEBLOCKBOUNCE 3.0f
#define VELNOTEBLOCKREPEL 5.0f
#define VELBLOCKBOUNCE  3.0f
#define VELBLOCKREPEL   3.0f
#define VELPOWERUPBOUNCE 8.1f
#define FIREBALLBOUNCE  5.0f
#define HAMMERTHROW     8.5f
#define VELMOVINGFRICTION 0.2f
#define VELICEFRICTION  0.06f
#define VELAIRFRICTION  0.06f
#define VELSTOPJUMP     5.0f
#define BOUNCESTRENGTH  0.5f
#define TAGGEDBOOST    1.0f

#define	GRAVITATION		0.40f		

#define MAXVELY			20.0f

#define CRUNCHVELOCITY	2
#define CRUNCHAMOUNT	16
#define CRUNCHMAX       32


#define MAPWIDTH		20			//width of the map
#define MAPHEIGHT		15			//height of the map
#define MAPLAYERS		4			//number of layers the map has
#define TILESIZE		32			//size of the tiles, should be dynamically read
#define PREVIEWTILESIZE	16			//size of the preview tiles
#define THUMBTILESIZE	8			//size of the thumbnail tiles
#define BLOCKSETSIZE	15			//size of block set
#define	MAXWARPS		32

#define NUMSPAWNAREATYPES 2
#define MAXSPAWNAREAS   128
#define MAXDRAWAREAS   128

#define MAX_PLAYER_SPAWN_TRIES 16

#define TILESETSIZE		960			//30*32 Tiles by 32 pixel in a 1024*1024 bmp
#define TILESETHEIGHT   30
#define TILESETWIDTH	32

#define MAXMUSICCATEGORY	11
#define MAXCATEGORYTRACKS	64

#define MAXEYECANDY		192
#define MAXOBJECTS		300
#define CORPSESTAY		200

#define MENUSPACING     36

#define WAITTIME		16		//delay between frames (default:16)
#define MAXAWARDS       10
#define MINAWARDSNEEDED 3

#define MAXTOURNAMENTGAMES 10

#define ifsoundonplay(x) (game_values.sound ? x.play() : -1)
#define ifsoundonandreadyplay(x) (x.isready() && game_values.sound ? x.play() : -1)
#define ifsoundonplayloop(x,y) (game_values.sound ? x.playloop(y) : -1)
#define ifsoundonstop(x) (game_values.sound ? x.stop() : void(NULL))
#define ifsoundonpause(x) (game_values.sound ? x.sfx_pause() : void(NULL))
#define ifmusiconplay(x) (game_values.music ? x.play() : -1)

#define ABS(x) (x>0?x:-x)

#define TWO_PI 6.2831853f
#define PI 3.1415292f
#define THREE_HALF_PI 4.7123890f
#define THREE_QUARTER_PI 2.3561945f
#define HALF_PI 1.5707963f
#define QUARTER_PI 0.7853982f

#define DEVICE_KEYBOARD -1

#define JOYSTICK_DEAD_ZONE 16384
#define MOUSE_X_DEAD_ZONE 0
#define MOUSE_Y_DEAD_ZONE 5

#define MOUSE_UP 323
#define MOUSE_DOWN 324
#define MOUSE_LEFT 325
#define MOUSE_RIGHT 326
#define MOUSE_BUTTON_START 327

#define JOY_STICK_1_UP 0
#define JOY_STICK_1_DOWN 1
#define JOY_STICK_1_LEFT 2
#define JOY_STICK_1_RIGHT 3

#define JOY_STICK_2_UP 4
#define JOY_STICK_2_DOWN 5
#define JOY_STICK_2_LEFT 6
#define JOY_STICK_2_RIGHT 7

#define JOY_HAT_UP 8
#define JOY_HAT_DOWN 9
#define JOY_HAT_LEFT 10
#define JOY_HAT_RIGHT 11
#define JOY_BUTTON_START 12

#define KEY_NONE -1

#define MENU_ITEM_NEIGHBOR_UP 0
#define MENU_ITEM_NEIGHBOR_DOWN 1
#define MENU_ITEM_NEIGHBOR_LEFT 2
#define MENU_ITEM_NEIGHBOR_RIGHT 3

#define NUM_POWERUPS 20

void GetNameFromFileName(char * szName, const char * szFileName);
std::string stripCreatorAndDotMap(const std::string &filename);

#define NUM_AUTO_FILTERS 8

//------------- data structures / selfmade include files -------------
#include "input.h"
#include "uimenu.h"
#include "uicontrol.h"
#include "menu.h"
#include "MapList.h"
#include "movingplatform.h"
#include "map.h"
#include "player.h"
#include "object.h"
//#include "HashTable.h"
#include "eyecandy.h"
#include "gamemodes.h"


//------------- global variables / etc -------------
//i know that using so much global variables is ugly, this will change somewhen

//gfx stuff
extern SDL_Surface		*screen;		//for gfx
extern SDL_Surface		*blitdest;		//for gfx
extern short			x_shake;
extern short			y_shake;

extern CMap				g_map;
extern CPlayer			*list_players[4];
extern short			list_players_cnt;

extern SDL_Joystick		**joysticks;
extern short			joystickcount;

extern CScore			*score[4];
extern short			respawn[4];
extern short			projectiles[4];
extern short			score_cnt;
extern CObjectContainer objectsfront;
extern CObjectContainer objectsplayer;
extern CObjectContainer objectcollisionitems;
extern CObjectContainer objectblocks;
extern CEyecandyContainer eyecandyfront;
extern CEyecandyContainer eyecandyback;

extern STextAward		awards[PAWARD_LAST];
extern sfxSound			sfx_announcer[PANNOUNCER_SOUND_LAST];

extern bool fResumeMusic;

extern sfxSound			sfx_mip;
extern sfxSound			sfx_deathsound;
extern sfxSound			sfx_jump;
extern sfxSound			sfx_skid;
extern sfxSound			sfx_capejump;

extern sfxSound			sfx_invinciblemusic;
extern sfxSound			sfx_extraguysound;
extern sfxSound			sfx_sprout;
extern sfxSound			sfx_collectpowerup;
extern sfxSound			sfx_collectfeather;
extern sfxSound			sfx_storepowerup;
extern sfxSound			sfx_breakblock;
extern sfxSound			sfx_bump;
extern sfxSound			sfx_coin;
extern sfxSound			sfx_fireball;
extern sfxSound			sfx_springjump;
extern sfxSound			sfx_timewarning;
extern sfxSound			sfx_hit;
extern sfxSound			sfx_chicken;
extern sfxSound			sfx_transform;
extern sfxSound			sfx_yoshi;
extern sfxSound			sfx_pause;
extern sfxSound			sfx_bobombsound;
extern sfxSound			sfx_areatag;
extern sfxSound			sfx_cannon;
extern sfxSound			sfx_burnup;
extern sfxSound			sfx_pipe;
extern sfxSound			sfx_thunder;
extern sfxSound			sfx_slowdownmusic;
extern sfxSound			sfx_storedpowerupsound;
extern sfxSound			sfx_kicksound;
extern sfxSound			sfx_racesound;
extern sfxSound			sfx_bulletbillsound;
extern sfxSound			sfx_boomerang;
extern sfxSound			sfx_spit;
extern sfxSound			sfx_starwarning;
extern sfxSound			sfx_powerdown;
extern sfxSound			sfx_switchpress;

extern sfxMusic			backgroundmusic[5];

extern gfxSprite        spr_tanooki, spr_statue;
extern gfxSprite		spr_starpowerup;
extern gfxSprite		spr_1uppowerup;
extern gfxSprite		spr_2uppowerup;
extern gfxSprite		spr_3uppowerup;
extern gfxSprite		spr_5uppowerup;
extern gfxSprite		spr_firepowerup;
extern gfxSprite		spr_hammerpowerup;
extern gfxSprite		spr_poisonpowerup;
extern gfxSprite		spr_mysterymushroompowerup;
extern gfxSprite		spr_boomerangpowerup;
extern gfxSprite		spr_clockpowerup;
extern gfxSprite		spr_bobombpowerup;
extern gfxSprite		spr_powpowerup;
extern gfxSprite		spr_modpowerup;
extern gfxSprite		spr_bulletbillpowerup;
extern gfxSprite		spr_featherpowerup;

extern gfxSprite		spr_shade[3];
extern gfxSprite		spr_timershade;
extern gfxSprite		spr_spawneggs;
extern gfxSprite		spr_scoretext;
extern gfxSprite		spr_racetext;
extern gfxSprite		spr_crown;
extern gfxSprite		spr_cape;

extern gfxSprite		spr_egg;
extern gfxSprite		spr_star;
extern gfxSprite		spr_flags;
extern gfxSprite		spr_frenzycards;
extern gfxSprite		spr_yoshi;
extern gfxSprite		spr_coin;
extern gfxSprite		spr_thwomp;
extern gfxSprite		spr_podobo;
extern gfxSprite		spr_bowserfire;
extern gfxSprite		spr_areas;
extern gfxSprite		spr_kingofthehillarea;
extern gfxSprite		spr_jail;
extern gfxSprite		spr_racegoal;
extern gfxSprite		spr_chicken;

extern gfxSprite		spr_goomba;
extern gfxSprite		spr_goombadead;
extern gfxSprite		spr_goombadeadflying;
extern gfxSprite		spr_koopa;
extern gfxSprite		spr_cheepcheep;
extern gfxSprite		spr_cheepcheepdead;
extern gfxSprite		spr_bulletbill;
extern gfxSprite		spr_bulletbilldead;

extern gfxSprite		spr_fireball;
extern gfxSprite		spr_hammer;
extern gfxSprite		spr_boomerang;
extern gfxSprite		spr_shell;
extern gfxSprite		spr_shelldead;
extern gfxSprite		spr_blueblock;

extern gfxSprite		spr_fireballexplosion;
extern gfxSprite		spr_frictionsmoke;
extern gfxSprite		spr_bobombsmoke;
extern gfxSprite		spr_explosion;
extern gfxSprite		spr_burnup;
extern gfxSprite		spr_spawnsmoke[4];
extern gfxSprite		spr_spawndoor[4];
extern gfxSprite		spr_bonus;
extern gfxSprite		spr_extralife;
extern gfxSprite		spr_award;
extern gfxSprite		spr_awardsolid;
extern gfxSprite		spr_awardsouls;
extern gfxSprite		spr_awardsoulspawn;
extern gfxSprite		spr_awardkillsinrow[4];
extern gfxSprite		spr_flagbases;
extern gfxSprite		spr_ownedtags;
extern gfxSprite		spr_warplock;
extern gfxSprite		spr_coinsparkle;
extern gfxSprite		spr_shinesparkle;
extern gfxSprite		spr_shellbounce;

extern gfxSprite		spr_storedpowerupsmall;
extern gfxSprite		spr_storedpoweruplarge;
extern gfxSprite		spr_powerupselector;

extern gfxSprite		spr_scoreboard;
extern gfxSprite		spr_abovearrows;

#ifndef _SMW_EDITOR
extern gfxFont			menu_font_small;
extern gfxFont			menu_font_large;
extern gfxFont			game_font_small;
extern gfxFont			game_font_large;

extern gfxSprite		spr_noteblock;
extern gfxSprite		spr_breakableblock;
extern gfxSprite		spr_powerupblock;
extern gfxSprite		spr_donutblock;
extern gfxSprite		spr_flipblock;
extern gfxSprite		spr_bounceblock;
extern gfxSprite		spr_throwblock;
extern gfxSprite		spr_switchblocks;
#endif

extern gfxSprite		spr_brokenyellowblock;
extern gfxSprite		spr_brokenflipblock;
extern gfxSprite		spr_brokenblueblock;

extern gfxSprite		** spr_player[4];
extern gfxSprite		** spr_chocobo[4];
extern gfxSprite		** spr_bobomb[4];
extern gfxSprite		spr_clouds[2];
extern gfxSprite		spr_ghosts[3];
extern gfxSprite		spr_background;
extern gfxSprite		spr_backmap;
extern gfxSprite		spr_frontmap;
extern gfxSprite		menu_backdrop;

extern gfxSprite		menu_shade;
extern gfxSprite		menu_smw;
extern gfxSprite		menu_version;
extern gfxSprite		menu_slider_bar;
extern gfxSprite		menu_plain_field;
extern gfxSprite		menu_player_select;
extern gfxSprite		menu_map_filter;
extern gfxSprite		menu_dialog;
extern gfxSprite		menu_stomp;
extern gfxSprite		menu_survival;
extern gfxSprite		menu_mode_small;
extern gfxSprite		menu_mode_large;
extern gfxSprite		spr_dialog;
extern gfxSprite		spr_dialogbutton;
extern gfxSprite		spr_tournament_background;
extern gfxSprite		spr_tournament_powerup_splash;
extern gfxSprite		spr_player_select_background;
extern gfxSprite		spr_player_select_ready;
extern gfxSprite		spr_ipfield;
extern gfxSprite		spr_selectfield;
extern gfxSprite		spr_selectfielddisabled;
extern gfxSprite		spr_map_filter_icons;
extern gfxSprite		spr_tour_markers;
extern gfxSprite		spr_menu_boxed_numbers;
extern gfxSprite		spr_thumbnail_platformarrows;
extern gfxSprite		spr_thumbnail_warps[2];

extern MapList maplist;
extern SkinList skinlist;
extern AnnouncerList announcerlist;
extern MusicList musiclist;
extern GraphicsList menugraphicspacklist;
extern GraphicsList gamegraphicspacklist;
extern SoundsList soundpacklist;
extern TourList tourlist;
extern FiltersList filterslist;

extern CGameMode	*gamemodes[GAMEMODE_LAST];
extern short		currentgamemode;

extern float CapFallingVelocity(float vel);
extern float CapSideVelocity(float vel);

extern int g_iNextNetworkID;
extern int g_iNextMessageID;
extern char szIPString[32];
//extern NetServer netServer;
//extern NetClient netClient;

extern short g_iDefaultPowerupWeights[];

//----------------- game options all parts of the game need -----------
enum gs{GS_MENU, GS_START_GAME, GS_GAME, GS_QUIT};

//tournament scores
struct ts
{
	short		wins;
	short		type[MAXTOURNAMENTGAMES];
	short		total;		//used for running total in a tour
};

struct JailGameModeSettings
{
	bool tagfree;			//Free jailed player by tagging on same team
	short timetofree;		//Time it takes for a jailed player to be freed
};

struct CoinGameModeSettings
{
	bool penalty;			//Player loses coin if stomped on
	short quantity;			//Number of coins to have on screen at one time
};

struct StompGameModeSettings
{
	short rate;				//How fast they spawn
	short enemyweight[3];	//What ratio the powerups are chosen
};

struct FlagGameModeSettings
{
	short speed;			//How fast to move bases
	bool touchreturn;		//Return to base if player touches their own flag
	bool pointmove;			//Move base after point
	short autoreturn;		//Time to automatically return flag to base
	bool homescore;			//Need your flag at home base to score
};

struct ChickenGameModeSettings
{
	bool usetarget;			//Display target around chicken
};

struct TagGameModeSettings
{
	bool tagontouch;		//Transfer tag on touch
};

struct StarGameModeSettings
{
	short time;				//Time to get rid or keep star
	bool shine;				//If we are playing shine mode vs. ztar mode
};

struct DominationGameModeSettings
{
	bool loseondeath;		//Player loses his bases on death
	bool stealondeath;		//Killing player steals bases on death
	bool relocateondeath;	//Owned bases relocate on player's death
	short relocationfrequency; //How fast the bases switch spots
	short quantity;			//Number of bases
};

struct KingOfTheHillModeSettings
{
	short areasize;			//size of the hill area, 2x2, 3x3 etc.
	short relocationfrequency;  //How often the hill switches spots
};

struct RaceGameModeSettings
{
	short quantity;			//How many race goals
	short speed;			//How fast goals move
	short penalty;			//If dead players lose all tagged, one tagged or none
};

struct FrenzyGameModeSettings
{
	short quantity;			//How many powerups spawn
	short rate;				//How fast they spawn
	bool storedshells;		//Shells become stored instead of active
	short powerupweight[12];	//What ratio the powerups are chosen
};

struct SurvivalGameModeSettings
{
	short enemyweight[3];       //The weighting of thwomps vs. podobos
	short density;				//Number of thwomps on screen
	short speed;				//How fast thwomps go
	bool shield;				//Players are shielded when spawning
};

struct GameModeSettings
{
	JailGameModeSettings jail;
	CoinGameModeSettings coins;
	StompGameModeSettings stomp;
	FlagGameModeSettings flag;
	ChickenGameModeSettings chicken;
	TagGameModeSettings tag;
	StarGameModeSettings star;
	DominationGameModeSettings domination;
	KingOfTheHillModeSettings kingofthehill;
	RaceGameModeSettings race;
	FrenzyGameModeSettings frenzy;
	SurvivalGameModeSettings survival;
};

struct TourStop
{
	const char * pszMapFile;
	short iMode;
	short iGoal;
	short iPoints;
	bool fBonusWheel;
	char szName[128];
};

//TODO:: Move menu settings form game_values to global menu context structure
//menu context (like game_values, but for menu)
/*
struct MenuContext
{
	
};

extern MenuContext menu_context;
*/

struct gv
{
	short		playercontrol[4];
	bool		showfps;
	bool		frameadvance;
	bool		autokill;
	short		framelimiter;
	
	bool		sound;
	bool		music;

	short		soundvolume;
	short		musicvolume;

	bool		fullscreen;
	gs			gamestate;

	float		screenResizeX;
	float		screenResizeY;
	float		screenResizeW;
	float		screenResizeH;

	short		flickerfilter;
	short		hardwarefilter;
	short		softfilter;
	bool		aspectratio10x11;

	CGameMode	*gamemode;

	short		spawnstyle;
	short		awardstyle;

	short		spawninvincibility;

	bool		pausegame;
	bool		exitinggame;
	bool		exityes;

	bool		showscoreboard;
	float		scorepercentmove;
	
	short		tournamentgames;
	bool		tournament;
	short		tournamentwinner;
	
	bool		tour;
	short		tourstopcurrent;
	short		tourstoptotal;
	std::vector<TourStop*> tourstops;
	
	short		slowdownon;
	short		slowdowncounter;

	short		storedpowerups[4];
	short		gamepowerups[4];
	short		powerupweights[NUM_POWERUPS];

	short		teamids[4][3];
	short		teamcounts[4];
	short		skinids[4];
	short		colorids[4];
	bool		randomskin[4];

	bool		screencrunch;
	short		screenshaketimer;
	CPlayer *	screenshakeplayer;
	bool		screenshakekillinair;
	short		screenshakekillscount;

	short		bulletbilltimer[4];
	short		bulletbillspawntimer[4];

	bool		friendlyfire;
	bool		toplayer;
	short		scoreboardstyle;
	bool		teamcolors;

	short		loadedannouncer;
	short		loadedmusic;

	short		teamdeadcounter;

	short		respawn;
	short		itemrespawntime;
	short		outofboundstime;

	short		warplocks;

	short		cputurn;
	short		cpudifficulty;

	short		networktype;		//Type of network game: 0=stand alone, 1=direct connect
	bool		networkhost;		//If this machine is the one making collision detection and game state changes
	bool		gamehost;			//If this client is responsible for choosing game type, map, options
	char *		hostaddress;        //String form of the host ip address

	//FIXME:: Trying out new controls to see if they work
	//Player controls configuration for both keyboard and joystick/gamepad
	CInputPlayerControl inputConfiguration[4][2]; //[NumPlayers][Keyboard/Joystick]

	//Player input used during game.  Reads SDL_Events and sets buttons that were pressed
	CPlayerInput playerInput;

	ts			tournament_scores[4];

	GameModeSettings gamemodesettings;
	
	short		fireballttl;
	short		fireballlimit;

	short		hammerdelay;
	short		hammerttl;
	bool		hammerpower;
	short		hammerlimit;

	short		boomerangstyle;
	short		boomeranglife;
	short		boomeranglimit;

	short		featherjumps;
	short		featherlimit;

	short		shellttl;
	short		blueblockttl;

	bool		playskidsound;
	bool		playinvinciblesound;

	short		swapstyle;
	bool		swapplayers;
	float		swapplayersposition;
	bool		swapplayersblink;
	short		swapplayersblinkcount;

	short		screenfade;
	short		screenfadespeed;

	short		storedpowerupdelay;
	short		bonuswheel;
	bool		keeppowerup;

	bool		showwinningcrown;

	bool		playnextmusic;  //automatically advance to the next music track after one finishes

	bool		soundcapable;

	bool *		pfFilters;
	short *		piFilterIcons;
	short		selectedmapfilter;
	bool		fNeedWriteFilters;
	bool		fFiltersOn;

	short		pointspeed;
};

extern gv game_values;

#endif

