#!/usr/bin/env python



import sys

import getopt

import gtk
import ctypes
import uuid
import glib
import time
import gobject

# Information taken from:
# http://docs.python.org/library/uuid.html#uuid.uuid4
# http://docs.python.org/library/ctypes.html
# http://www.dalkescientific.com/writings/NBN/ctypes.html
# Class constructed from: http://maemo.gitorious.org/maemo-rtcom/rtcom-eventlogger/blobs/master/rtcom-eventlogger/event.h
# credits to gri for doing the hard work with this


class RTComElEvent(ctypes.Structure):
    _fields_ = [("_mask", ctypes.c_int),
                ("fld_id", ctypes.c_int),
                ("fld_service_id", ctypes.c_int),
                ("fld_event_type_id", ctypes.c_int),
                ("fld_storage_time", ctypes.c_long), # time_t
                ("fld_start_time", ctypes.c_long), # time_t
                ("fld_end_time", ctypes.c_long), # time_t
                ("fld_is_read", ctypes.c_int), # Boolean is int
                ("fld_flags", ctypes.c_int),
                ("fld_bytes_sent", ctypes.c_int),
                ("fld_bytes_received", ctypes.c_int),
                ("fld_local_uid", ctypes.c_char_p),
                ("fld_local_name", ctypes.c_char_p),
                ("fld_remote_uid", ctypes.c_char_p),
                ("fld_remote_name", ctypes.c_char_p),
                ("fld_remote_ebook_uid", ctypes.c_char_p),
                ("fld_channel", ctypes.c_char_p),
                ("fld_free_text", ctypes.c_char_p),
                ("fld_group_uid", ctypes.c_char_p),
                ("fld_service", ctypes.c_char_p),
                ("fld_event_type", ctypes.c_char_p),
                ("fld_additional_text", ctypes.c_char_p),
                ("fld_icon_name", ctypes.c_char_p),
                ("fld_pango_markup", ctypes.c_char_p)]


def put_to_sent_sms(name, number, uniqueid, groupid, tme, message, g):
    rtcom = ctypes.CDLL('librtcom-eventlogger.so.1') # PR 1.2
    #rtcom = ctypes.CDLL('librtcom-eventlogger.so.0') # PR 1.1

    el = ctypes.cast(rtcom.rtcom_el_new(), ctypes.c_void_p)
    event = ctypes.cast(rtcom.rtcom_el_event_new(), ctypes.POINTER(RTComElEvent))[0]

    event._mask       |= 1 << 18
    event.fld_service  = 'RTCOM_EL_SERVICE_SMS'

    event._mask       |= 1 << 19
    event.fld_event_type = 'RTCOM_EL_EVENTTYPE_SMS_'+g+'BOUND'

    event._mask       |= 1 << 4
    event.fld_start_time = tme

    event._mask       |= 1 << 5
    event.fld_end_time = tme

    event._mask       |= 1 << 6
    event.fld_is_read = 1 # TRUE

    event._mask       |= 1 << 10
    event.fld_remote_ebook_uid = uniqueid

    event._mask       |= 1 << 11
    event.fld_local_uid = 'ring/tel/ring'

    event._mask       |= 1 << 12
    event.fld_local_name = '<SelfHandle>'

    event._mask       |= 1 << 13
    event.fld_remote_uid = number

    event._mask       |= 1 << 14
    event.fld_remote_name = name

    event._mask       |= 1 << 17
    event.fld_group_uid = groupid

    event._mask       |= 1 << 16
    event.fld_free_text = message

    print "adding event..."
    rtcom.rtcom_el_add_event.argtypes = [el, ctypes.c_void_p, ctypes.c_void_p]
    eventId = rtcom.rtcom_el_add_event(el, ctypes.byref(event), None)
    print "added event: %s" % eventId


    # the follwing block doesnt seem to be needed for SMS
    # Add the message that it shows up in conversations
    rtcom.rtcom_el_add_header.argtypes = [el, ctypes.c_int, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_void_p]
    rtcom.rtcom_el_add_header(el, eventId, 'message-token', str(uuid.uuid4()), None)

    rtcom.rtcom_el_event_free(ctypes.byref(event))
    #glib.g_object_unref(el)

class xEntry(gtk.Entry):
    def __init__(self, allowedchars):
        gtk.Entry.__init__(self)
        self.allowedchars=allowedchars
        self.connect("changed", self.charcheck, None)

    def charcheck(self, widget, string, *args):
        pos = widget.get_position()
        char = widget.get_chars(pos, pos + 1)
        if char not in self.allowedchars:
            widget.select_region(pos, pos + 1)
            widget.delete_selection()

class EntryDialog( gtk.Dialog):

    def __init__(self, message="", default_text='', modal= gtk.TRUE):

        gtk.Dialog.__init__(self)

        self.connect("destroy", self.quit)

        self.connect("delete_event", self.quit)

        if modal:

            self.set_modal(gtk.TRUE)

        box = gtk.VBox(spacing=10)

        box.set_border_width(10)

        self.vbox.pack_start(box)

        box.show()

        if message:

            label = gtk.Label('Mobile Number')

            box.pack_start(label)

            label.show()

        self.entry = xEntry("+1234567890.")

        self.entry.set_text(default_text)

        box.pack_start(self.entry)

        self.entry.show()

        self.entry.grab_focus()
	
	label = gtk.Label('Message')

        box.pack_start(label)

        label.show()	

	self.entry2 = gtk.Entry()

        self.entry2.set_max_length(160)

	box.pack_start(self.entry2)

        self.entry2.show()

	label = gtk.Label('Minutes since you should have sent TXT')

        box.pack_start(label)

        label.show()

	self.entry3 = xEntry("1234567890.")

	box.pack_start(self.entry3)

        self.entry3.show()

        label = gtk.Label('IN or OUT')

        box.pack_start(label)

        label.show()

	self.entry4 = gtk.Entry()

	box.pack_start(self.entry4)

        self.entry4.show()


        button = gtk.Button("OK")

        button.connect("clicked", self.click)

        button.set_flags(gtk.CAN_DEFAULT)

        self.action_area.pack_start(button)

        button.show()

        button.grab_default()

        button = gtk.Button("Cancel")

        button.connect("clicked", self.quit)

        button.set_flags(gtk.CAN_DEFAULT)

        self.action_area.pack_start(button)

        button.show()

        self.ret = None

    def quit(self, w=None, event=None):

        self.hide()

        self.destroy()

        gtk.mainquit()

    def click(self, button):
	foo=self.entry.get_text()
	foo2=self.entry2.get_text()
	foo3=int(self.entry3.get_text())
        tm=int(time.time() - foo3 * 60)
        nr = foo
	# grp is last 7 (or fewer) digits/whatever
	grp = nr[-7:]
	msg = foo2
	m=self.entry4.get_text()
        sendername = "" # do we really need to specify this ourselves? :(
	put_to_sent_sms(sendername, nr, 0, grp, tm, msg, m)
        



def input_box(title="Input Box", message="", default_text='',

        modal= gtk.TRUE):

    win = EntryDialog(message, default_text, modal=modal)

    win.set_title(title)

    win.show()

    gtk.mainloop()

    return win.ret



def test():

    result = input_box(title='SMS FAKER',

        message='Fake SMS:',

        default_text='')

    if result is None:

        print 'Canceled'

    else:

        print 'result: "%s"' % result



USAGE_TEXT = """

Usage:

    python simple_dialog.py [options]

Options:

    -h, --help      Display this help message.

Example:

    python simple_dialog.py

"""



def usage():

    print USAGE_TEXT

    sys.exit(-1)



def main():

    args = sys.argv[1:]

    try:

        opts, args = getopt.getopt(args, 'h', ['help'])

    except:

        usage()

    relink = 1

    for opt, val in opts:

        if opt in ('-h', '--help'):

            usage()

    if len(args) != 0:

        usage()

    test()



if __name__ == '__main__':

    main()

    #import pdb

    #pdb.run('main()')
