#Run it manually:
# cd /usr/lib/hildon-desktop
# python2.5 sleeper.py

import gtk
import pygtk
import hildon
import hildondesktop
import dbus
import os
 
class SleeperHomePlugin(hildondesktop.HomePluginItem):

  def __init__(self):
    hildondesktop.HomePluginItem.__init__(self)

    #Draw the widget buttons
    button15 = gtk.Button("15")
    button15.set_size_request(48, 48)
    button15.connect("button-press-event", self.on_button_press_event, 15)
    button15.show_all()
    
    button30 = gtk.Button("30")
    button15.set_size_request(64,64) 
    button30.connect("button-press-event", self.on_button_press_event, 30)
    button30.show_all()
    
    hbox = gtk.VBox(True) 
    hbox.pack_start(button15)
    hbox.pack_start(button30)
    self.add(hbox) 
    self.set_opacity(0.5)
    hbox.show()
    
  def on_button_press_event(self, widget, button, data):  
    banner = hildon.hildon_banner_show_information(self, "", "sleeper: " + "15 minutes to go, sleep well...")
    banner.set_timeout(2000)
    gobject.timeout_add_seconds(data * 60, self.sleeptimer_cb)
  
  def sleeptimer_cb(self):
    #Stop the music   
    bus = dbus.SessionBus()
    gstrenderer = bus.get_object('com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer',
                        '/com/nokia/mafw/renderer/gstrenderer')
    gstrenderer.pause(dbus_interface="com.nokia.mafw.renderer")
    banner = hildon.hildon_banner_show_information(self, "", "sleeper: " + "Mediaplayer paused, sleep well...")
    banner.set_timeout(2000)
    return False
          
hd_plugin_type = SleeperHomePlugin

# The code below is just for testing purposes.
# It allows to run the widget as a standalone process.
if __name__ == "__main__":
    import gobject
    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id="plugin_id")
    obj.show_all()
    gtk.main()

    