# -*- coding: utf-8 -*-

import sys
import os
#import random
import time
from time import strftime
#import math
#import array
import string

import ConfigParser
import os, os.path

import data
import filter_data #filter
import records #record data


#load language file
import i18n
#_ = i18n.language.gettext
_ = i18n.language.ugettext

###########################################################################
## Load the configuration from the config file
###########################################################################
def LoadConfig():
    #get configuration
    global config
    if(data.debug==True): print "Configuration file:",  data.configFolder+data.ConfigFile
    config = ConfigParser.SafeConfigParser()
    try:
        config.read(data.configFolder+data.ConfigFile)
    except: #use default config
        print "Configuration file "+data.configFolder+data.ConfigFile + " not existing or not compatible"

    try:
        config.add_section('main')
    except:
        pass

    try:
        configFileVersion = config.getint('main', 'configFileVersion')
    except:
        configFileVersion=0
    if(configFileVersion<data.configFileVersion): #config file is old, update some parameters...
        print "(not yet used) Configuration file is old, update parameters..."
    else: #config file up to date
        pass


    try:
        data.Sampling_interval = config.getint('main', 'sampling')
    except:
        config.set('main', 'sampling', str(data.Sampling_interval))

    try:
        data.Sample_smoothing = config.getint('main', 'sample_smoothing')
    except:
        config.set('main', 'sample_smoothing', str(data.Sample_smoothing))

    try:
        data.Value_smoothing = config.getint('main', 'value_smoothing')
    except:
        config.set('main', 'value_smoothing', str(data.Value_smoothing))

    try:
        data.Trigger = config.getint('main', 'Trigger')
    except:
        config.set('main', 'Trigger', str(data.Trigger))

    try:
        data.Derivation = config.getint('main', 'Derivation')
    except:
        config.set('main', 'Derivation', str(data.Derivation))

    try:
        data.Ysize = config.getint('main', 'Ysize')
    except:
        config.set('main', 'Ysize', str(data.Ysize))

    try:
        data.Xscale = config.getint('main', 'Xscale')
    except:
        config.set('main', 'Xscale', str(data.Xscale))

    try:
        data.Yscale = config.getint('main', 'Yscale')
    except:
        config.set('main', 'Yscale', str(data.Yscale))

    try:
        data.derivation_offset = config.getint('main', 'derivation_offset')
    except:
        config.set('main', 'derivation_offset', str(data.derivation_offset))

    try:
        data.FilterScale = config.getint('main', 'FilterScale')
    except:
        config.set('main', 'FilterScale', str(data.FilterScale))

    try:
        data.limitMovement = config.getint('main', 'limitMovement')
    except:
        config.set('main', 'limitMovement', str(data.limitMovement))

    try:
        tmp=config.get('main', 'user')
        data.user = tmp.decode("utf-8")
    except:
        config.set('main', 'user', str(data.user.encode( "utf-8" )))

    try:
        data.LastRecord = config.get('main', 'LastRecord')
    except:
        config.set('main', 'LastRecord', str(data.LastRecord))

    try:
        tmp = config.get('main', 'OfflineMode')
        if(tmp=="True"): data.OfflineMode=True
        else: data.OfflineMode=False
    except:
        config.set('main', 'OfflineMode', str(data.OfflineMode))

    try:
        tmp = config.get('main', 'SilentProfile')
        if(tmp=="True"): data.SilentProfile=True
        else: data.SilentProfile=False
    except:
        config.set('main', 'SilentProfile', str(data.SilentProfile))

    try:
        data.DelayStartTime = config.getint('main', 'DelayStartTime')
    except:
        config.set('main', 'DelayStartTime', str(data.DelayStartTime))

    try:
        data.AlarmHour = config.getint('main', 'AlarmHour')
    except:
        config.set('main', 'AlarmHour', str(data.AlarmHour))

    try:
        data.AlarmMinute = config.getint('main', 'AlarmMinute')
    except:
        config.set('main', 'AlarmMinute', str(data.AlarmMinute))

    try:
        data.AlarmTimeWindow = config.getint('main', 'AlarmTimeWindow')
    except:
        config.set('main', 'AlarmTimeWindow', str(data.AlarmTimeWindow))

    try:
        tmp = config.get('main', 'StopAfterAlarm')
        if(tmp=="True"): data.StopAfterAlarm=True
        else: data.StopAfterAlarm=False
    except:
        config.set('main', 'StopAfterAlarm', str(data.StopAfterAlarm))

    print "Configuration successful loaded from "+data.ConfigFile

    return config









###########################################################################
## Write the configuration into the config file
###########################################################################
def WriteConfig():
        global config
        config.set('main', 'Trigger', str(data.Trigger))
        config.set('main', 'ConfigFileVersion', str(data.configFileVersion))

        f=data.configFolder+data.ConfigFile
        if(data.debug==True): print "Save configuration ("+f+")"
        if (not os.path.exists(data.configFolder)):
            print "Create configuration folder: ",  data.configFolder
            os.mkdir(data.configFolder)
        try:
            data.configfile = open(f, 'w')
            config.write(data.configfile)
            data.configfile.close()
            print "Configuration saved"
        except:
            print "Failed to write configuration file!"







###########################################################################
##
###########################################################################
def Seconds2Tuple(secs):
    tuple=time.localtime(secs)
    return tuple



###########################################################################
##
###########################################################################
def Tuple2Seconds(Tuple):
    secs=int(time.mktime(Tuple))
    return secs



###########################################################################
##
###########################################################################
def Tuple2Index(Tuple):
    t0=records.StartTime_seconds
    t1=Tuple2Seconds(Tuple)
    tdiff=t1-t0
#    print records.StartTime_tuple,  Tuple
#    print "Tuple2Index:",  t0,  t1,  tdiff,  float(1000)/(records.Sampling_interval*records.Value_smoothing)
#    return Seconds2Index(tdiff)
    return int((tdiff-10)*1000/(records.Sampling_interval*records.Value_smoothing))+3



###########################################################################
##
###########################################################################
def Index2Tuple(Index):
    tdiff=int(Index*records.Sampling_interval*records.Value_smoothing/1000-3)+10
#    tdiff=Index2Seconds(Index)
    t=records.StartTime_seconds+tdiff
    return Seconds2Tuple(t)








def SwitchModes(start):
    if(data.demo==False): #We are on a N900
        if(data.QuickMode==False):  #only do in normal recording mode

            if(start==True): #start of recording
                if(data.SwitchedModes==False): #protection so it only gets switched once
                    data.SwitchedModes=True
                    if(data.OfflineMode==True): #change to offline mode
                        try:
                            cmd="dbus-send --system --dest=com.nokia.mce --print-reply --type=method_call /com/nokia/mce/request com.nokia.mce.request.get_device_mode"
                            ret=os.popen2(cmd) #get current mode
                            p=ret[1].readline() #not used
                            p=ret[1].readline()
                            tmp=string.split(p,  "\"")
                            data.PreviousMode=tmp[1]
                            if(data.PreviousMode=="normal"): #was normal, change to offline
                                print "Change to offline mode"
                                cmd="dbus-send --system --dest=com.nokia.mce --type=method_call /com/nokia/mce/request com.nokia.mce.request.req_device_mode_change string:\"offline\""
                                os.popen(cmd)
                        except:
                            pass

                    if(data.SilentProfile==True): #change to silent profile
                        try:
                            cmd="dbus-send --type=method_call --print-reply --dest=com.nokia.profiled /com/nokia/profiled com.nokia.profiled.get_profile"
                            ret=os.popen2(cmd) #get current profile
                            p=ret[1].readline() #not used
                            p=ret[1].readline()
                            tmp=string.split(p,  "\"")
                            data.PreviousProfile=tmp[1]
                            if(data.PreviousProfile=="general"): #was general profile, change to silent profile
                                cmd="dbus-send --type=method_call --dest=com.nokia.profiled /com/nokia/profiled com.nokia.profiled.set_profile string:\"silent\" | echo \"\""
                                os.popen(cmd)
                                txt=_("Silent Profile activated")
                                print txt
                                cmd="dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\""+txt+"\""
                                os.popen(cmd)
                        except:
                            pass



            else: #end of recording
                if(data.SwitchedModes==True): #protection so it only gets switched once
                    data.SwitchedModes=False
                    if(data.OfflineMode==True and data.demo!=1): #change to online mode
                        try:
                            if(data.PreviousMode=="normal"): #was online mode (before start measurement), so restore
                                print "Change to online mode"
                                cmd="dbus-send --system --dest=com.nokia.mce --type=method_call /com/nokia/mce/request com.nokia.mce.request.req_device_mode_change string:\"normal\""
                                os.popen(cmd)
                        except:
                            pass
                    if(data.SilentProfile==True and data.demo!=1): #change to general profile
                        try:
                            if(data.PreviousProfile=="general"): #was general (before start measurement), so restore to general
                                cmd="dbus-send --type=method_call --dest=com.nokia.profiled /com/nokia/profiled com.nokia.profiled.set_profile string:\"general\" | echo \"\""
                                os.popen(cmd)  #set profile
                                txt=_("General Profile activated")
                                cmd="dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\""+txt+"\""
                                os.popen(cmd)  #notification
                        except:
                            pass










############################################################################
## Function to measure used time in a function
############################################################################
#def Show_passed_time(text="",  reset=0):
#    if(data.debug==False): return
#    now=time.time()
#    if(reset==1): data.passed_time=now
#
#    t=1000*(now-data.passed_time)
#    t2=1000*(now-data.passed_time2)
#    print "### ",  str(int(t)), "ms, (",  str(int(t2)), "ms delta): ", text
#
#    data.passed_time2 = time.time()
