import sys
import os
import random
import time
from time import strftime
import math
import array
import string

import ConfigParser
import os, os.path

import data
import records #record data

    
###########################################################################
# Load the configuration from the config file
###########################################################################
def LoadConfig():    
    #get configuration
    global config
    print "Configuration file:",  data.configfolder+data.ConfigFile
    config = ConfigParser.SafeConfigParser()
    try:
        config.read(data.configfolder+data.ConfigFile)
        
        data.Sampling_interval = config.getint('main', 'sampling')
        data.sample_smoothing = config.getint('main', 'sample_smoothing')
        data.Value_smoothing = config.getint('main', 'value_smoothing')
        data.Trigger = config.getint('main', 'Trigger')
        data.Derivation = config.getint('main', 'Derivation')
        data.Ysize = config.getint('main', 'Ysize')
        data.Xscale = config.getint('main', 'Xscale')
        data.Yscale = config.getint('main', 'Yscale')
        data.user = config.get('main', 'user')
        data.lastlogfile = config.get('main', 'lastlogfile')
        data.OfflineMode = config.get('main', 'OfflineMode')
        data.DelayStartTime = config.getint('main', 'DelayStartTime')
        data.AlarmHour = config.getint('main', 'AlarmHour')
        data.AlarmMinute = config.getint('main', 'AlarmMinute')
        data.AlarmTimeWindow = config.getint('main', 'AlarmTimeWindow')
        print "Configuration loaded ("+data.ConfigFile+")"
        
    except: #use default config
        print data.configfolder+data.ConfigFile + " not existing or not read properly, using default parameters..."
        try:
            config.add_section('main')
        except:
            pass
        config.set('main', 'sampling', str(data.Sampling_interval))
        config.set('main', 'sample_smoothing', str(data.sample_smoothing))      
        config.set('main', 'value_smoothing', str(data.Value_smoothing))      
        config.set('main', 'Trigger', str(data.Trigger))      
        config.set('main', 'Derivation', str(data.Derivation))      
        config.set('main', 'Ysize', str(data.Ysize))      
        config.set('main', 'Xscale', str(data.Xscale))     
        config.set('main', 'Yscale', str(data.Yscale))      
        config.set('main', 'user', str(data.user))      
        config.set('main', 'lastlogfile', str(data.lastlogfile))    
        config.set('main', 'OfflineMode', str(data.OfflineMode))      
        config.set('main', 'DelayStartTime', str(data.DelayStartTime))    
        config.set('main', 'AlarmHour', str(data.AlarmHour))    
        config.set('main', 'AlarmMinute', str(data.AlarmMinute))    
        config.set('main', 'AlarmTimeWindow', str(data.AlarmTimeWindow))    

    return config





###########################################################################
# Write the configuration into the config file
###########################################################################
def WriteConfig():    
        global config
        config.set('main', 'Trigger', str(data.Trigger))  
        
        f=data.configfolder+data.ConfigFile
        print "Save configuration ("+f+")"
        if (not os.path.exists(data.configfolder)):
            print "Create configuration folder: ",  data.configfolder
            os.mkdir(data.configfolder)
        try:
            data.configfile = open(f, 'w')
            config.write(data.configfile)
            print "Configuration saved"
        except:
            print "Failed to write configuration file!"
    
    
    
    
    
    
    
    
def Seconds2Tuple(secs):
    tuple=time.localtime(secs)
    return tuple
    
    
    
    
def Tuple2Seconds(Tuple):
    secs=int(time.mktime(Tuple))
    return secs

    
    

def Tuple2Index(Tuple):
    t0=records.StartTime_seconds
    t1=Tuple2Seconds(Tuple)
    tdiff=t1-t0
#    print records.StartTime_tuple,  Tuple
#    print "Tuple2Index:",  t0,  t1,  tdiff,  float(1000)/(records.Sampling_interval*records.Value_smoothing)
#    return Seconds2Index(tdiff)
    return int((tdiff-10)*1000/(records.Sampling_interval*records.Value_smoothing))+3
    
    
    
    
def Index2Tuple(Index):
    tdiff=int(Index*records.Sampling_interval*records.Value_smoothing/1000-3)+10
#    tdiff=Index2Seconds(Index)
    t=records.StartTime_seconds+tdiff
    return Seconds2Tuple(t)
    
    
#def Seconds2Index(secs):
#    return int((secs-10)*1000/(records.Sampling_interval*records.Value_smoothing))+3

#def Index2Seconds(Index):
#    return int(Index*records.Sampling_interval*records.Value_smoothing/1000-3)+10
    

############################################################################
## Function to measure used time in a function
############################################################################
#def Show_passed_time(text="",  reset=0):
#    if(data.debug==0): return
#    now=time.time()
#    if(reset==1): data.passed_time=now
#    
#    t=1000*(now-data.passed_time)
#    t2=1000*(now-data.passed_time2)
#    print "### ",  str(int(t)), "ms, (",  str(int(t2)), "ms delta): ", text
#
#    data.passed_time2 = time.time()
