import sys
import os
import random
import time
from time import strftime
import math
import array
import string

import ConfigParser
import os, os.path

import data
import records #record data

#own functions
from functions_general import *


###########################################################################
## Read the sensor data x times and smoothen it
###########################################################################
def ReadAccSensor():    
    coords=[0, 0]    
    if(data.demo==False):        
        for i in range(data.sample_smoothing):
            f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", 'r' )
            coords_tmp = [int(w) for w in f.readline().split()]
            f.close()
            coords[0]=coords[0] + coords_tmp[0] #X
            coords[1]=coords[1] + coords_tmp[1] #Y
        coords[0]=coords[0] / data.sample_smoothing
        coords[1]=coords[1] / data.sample_smoothing
    else:
        coords[0]=int(random.uniform(-50,50))
        coords[1]=int(random.uniform(-50,50))
    return coords



###########################################################################
## Get the smoothened sensor data, smoothen it again and fill the data into the main data array
###########################################################################
def GetSensorData():    
    d=ReadAccSensor()
    data.arrDataTemp[0]=data.arrDataTemp[0]+d[0]
    data.arrDataTemp[1]=data.arrDataTemp[1]+d[1]

    data.sample_index=data.sample_index+1
    
    if(data.sample_index==data.Value_smoothing): #if is 10 runs over        
        data.sample_index=0
        data.Values_total=data.Values_total+1
        
        if(records.Index==records.MaxArrayDataLen-1): return 0 #Array full
        
        records.arrData[0][records.Index]=strftime("%H:%M:%S", time.localtime())
        records.arrData[1][records.Index]=data.arrDataTemp[0]/data.Value_smoothing
        records.arrData[2][records.Index]=data.arrDataTemp[1]/data.Value_smoothing
        
        records.Index=records.Index+1
        records.LastIndex=max(records.Index,  records.LastIndex)

        data.arrDataTemp[0]=0
        data.arrDataTemp[1]=0

        return 1 #added new values to arrData        
    else: return 0 #no new data added






###########################################################################
##  Process the data, generate movement indication
###########################################################################
def ProcessData(ProcessAll=False):  #DERIVATION (ABLEITUNG)
    lastmovebeforegraph=0 
    if(ProcessAll==True): start=0 #process whole array
    else: start=records.Index-data.Derivation-1 #process only last (changed) records
    
    for i in range(start, records.Index-data.Derivation):     
        t=i*(records.Sampling_interval*records.Value_smoothing)/1000
        if(data.QuickMode==True or t>data.DelayStartTime):
            Xder=records.arrData[1][i+data.Derivation] - records.arrData[1][i] #X  in 5 sec - X now
            Yder=records.arrData[2][i+data.Derivation] - records.arrData[2][i]  #Y  in 5 sec - Y now
            XYder=abs(Xder)+abs(Yder) #summ of both absolute Derivations
        else: #During delayed phase, do not use data
            Xder=0
            Yder=0
            XYder=0
        records.arrData[3][i]=min(XYder*data.Yscale,  data.Ysize-17) #cut off if higer than graph border









###########################################################################
## Show (refreshs) the graph.
## the parameter indcates on which window it will be drawn
###########################################################################
def showGraph(self,  QtGui):
    if(data.ChangesInGraph==False): 
        if(data.debug==1): print "------>         Do not redraw, nothing changed!"
        return 
        
    ScrollbarStartPercent, ScrollbarEndPercent=ScrollbarData()
    Xscale=data.arrXscale[data.Xscale]
   
#        print "-----------------------------------"
#        print "Xscale:",  Xscale
#        print "Current index:",  records.Index
#        print "LastIndex:",  records.LastIndex
#        print "GraphLen (WindowSize):",  data.GraphLen
#        print "GraphStart:",  data.GraphStart
#        print "GraphEnd:",  data.GraphEnd
#        print "The area between index",data.GraphStart , "and",data.GraphEnd , "will be shown"
#        print "Scrollbar:",  ScrollbarStartPercent, "...", ScrollbarEndPercent, "%"
    
#        print "Shown graph is from index",  data.GraphStart,  "to",  data.GraphStart+GraphLen
        
#    PrintRecordData()
        
    data.ChangesInGraph=False
    paint = QtGui.QPainter()
    paint.begin(self)

    paint.setFont(QtGui.QFont('Decorative', 12))
    paint.setPen(QtGui.QColor("white"))
    paint.setBrush(QtGui.QColor("black"))
    
    paint.drawRect(0,0,781,data.Ysize)    #show Graph border        
    
    
    
    #Stop if data is not ok
    if(records.statusID!="OK"):#Show useful infos                 
        paint.setFont(QtGui.QFont('Decorative', 20))
        paint.setPen(QtGui.QColor("White"))  
        paint.drawText(100, data.Ysize/2+5, records.status) #show status information
        return
    

    h0=int(strftime("%H", Index2Tuple(data.GraphStart)))
    m0=int(strftime("%M", Index2Tuple(data.GraphStart)))
            
    #decade (scaling):
    #6 => 60px/h
    #1 => 360px/h
    decade=360/Xscale
    minutestonexthour=60-m0
    offset=minutestonexthour*decade/60

    
    #DRAW main scaling lines + text        
    paint.setPen(QtGui.QColor("white"))
    if(data.QuickMode==False): #normal mode
        for i in range(-1*decade, 781+decade,  decade):
            paint.drawLine(i+offset, data.Ysize, i+offset, data.Ysize+10)  
            for k in range(1, 6):
                x=i+offset+k*decade/6-decade
                paint.drawLine(x, data.Ysize, x, data.Ysize+5)  
            h=(h0+int(i/decade)+1) % 24
            paint.drawText(i+offset-15, data.Ysize+30, str(h)+":00") 
            if(data.Xscale==0): #add extra marks/numbers on biggest zoom level
                for k in range(1, 6):  paint.drawText(i+offset-15+k*decade/6, data.Ysize+23, str(h)+":"+str(10*k))
                for k in range(1, 12): paint.drawLine(x+decade/12*k, data.Ysize, x+decade/12*k, data.Ysize+5)
    else: #test mode, do not show X scale as it is not calibrated
        paint.drawText(200, data.Ysize+20, "Test Mode")


    #DRAW scroll bar 
    if(ScrollbarStartPercent>0 or ScrollbarEndPercent<100):
        paint.setPen(QtGui.QColor("gray"))
        paint.drawRect(0,data.Ysize+37,779,7)
        paint.setPen(QtGui.QColor("white"))
        paint.setBrush(QtGui.QColor("white"))
#        print ScrollbarStartPercent,  ScrollbarEndPercent
        x0=int(779*math.floor(ScrollbarStartPercent)/100)
        x1=int(779*math.ceil(ScrollbarEndPercent)/100)
#        print x0,  x1
        paint.drawRect(x0,  data.Ysize+38, x1-x0 ,  5)


    #DRAW graph + time bars
    paint.setPen(QtGui.QColor("yellow"))        
    lastmovebeforegraph=0        
    peak=0
            
    #get data for very first time bar
    for m in range(data.GraphStart,  0,  -1):    #find last peak before shown graph
        if(records.arrData[3][m]>records.Trigger): 
            lastmovebeforegraph=m-data.GraphStart
            break

    
    lastdatapoint=records.Index
    for p in range(data.GraphStart,  records.Index-data.Derivation,  Xscale):
        i=p-data.GraphStart
        if(i>779*Xscale): break
        #when Xscale is small, we have to merge several records into 1 pixel.
        #Too not miss any movement, we use the biggest movement of the merged records:
        peak=0            
        for j in range(0, Xscale): 
            if(records.arrData[3][p+j]>peak): peak=records.arrData[3][p+j]

        paint.drawLine(i/Xscale+1, data.Ysize-peak-1-15, i/Xscale+1, data.Ysize-1-15)  #draw yellow movement bar

        #draw time bars
        if(peak>records.Trigger): 
            lastdatapoint=p # used for last time bar
            x0=max(lastmovebeforegraph/Xscale+1, 0)
            if(x0==1):  x0=0
            x1=i/Xscale-1
            if(x0<x1): 
                    t=(x1-x0)*Xscale/6          
                    if(t>30): color="#009100" #green
                    elif(t>15): color="#005000" #dark green
                    elif(t>7): color="#97320e" #orange
                    else: color="#6D0000" #dark red                   
                    paint.setBrush(QtGui.QColor(color))
                    paint.setPen(QtGui.QColor(color))
                    paint.drawRect(x0+1, data.Ysize-11, x1-x0-1, 10)                     
                    paint.setPen(QtGui.QColor("yellow"))
            lastmovebeforegraph=i
            
            
    # Draw very last time bar
    x0=(lastdatapoint-data.GraphStart)/Xscale+1
    x1=(records.Index-data.GraphStart-data.Derivation)/Xscale
    if(x0<x1):
        t=(x1-x0)*Xscale/6          
        if(t>30): color="#009100" #green
        elif(t>15): color="#005000" #dark green
        elif(t>7): color="#97320e" #orange
        else: color="#6D0000" #dark red                   
        paint.setBrush(QtGui.QColor(color))
        paint.setPen(QtGui.QColor(color))                    
        x1=min(779, x1)
        paint.drawRect(x0+1, data.Ysize-11, x1-x0-1, 10)   
        
        
    #check if at least one grapth is drawn
    if(lastmovebeforegraph==0): #no interuption in whole graph
        x0=0
        x1=(records.Index-data.GraphStart-data.Derivation)/Xscale
        if(x0<x1):
            t=(x1-x0)*Xscale/6          
            if(t>30): color="#009100" #green
            elif(t>15): color="#005000" #dark green
            elif(t>7): color="#97320e" #orange
            else: color="#6D0000" #dark red                  
            paint.setBrush(QtGui.QColor(color))
            paint.setPen(QtGui.QColor(color))                    
            paint.drawRect(x0+1, data.Ysize-11, x1-x0-1, 10)   
        
        
        
    
   #ALARM VISUALISATION
    if(records.AlarmIsSet==True): #alarm time window is set, show it            
        paint.setBrush(QtGui.QColor("Orange"))
        paint.setPen(QtGui.QColor("Orange"))  
        x0=Tuple2Index(records.AlarmTimeWindowStart_tuple)
        x1=Tuple2Index(records.AlarmTimeWindowEnd_tuple)
        x00=(x0+3-data.GraphStart)/Xscale
        x10=(x1+3-data.GraphStart)/Xscale
        print "AlarmTimeWindow is on index", x0, "...", x1,  x00,  x10
        paint.drawRect(x00,  8,  x10-x00,  2) #Time Window 
        paint.drawRect(x10,  4,  1,  10)  #Last Alarm opportunity
     
        paint.setBrush(QtGui.QColor("Red"))
        paint.setPen(QtGui.QColor("Red"))  
        a0=Tuple2Index(records.AlarmTime_tuple)
        a00=(a0+3-data.GraphStart)/Xscale
        print "Alarm is on index",  a0,  a00
        paint.drawEllipse(a00-5, 15, 10, 10)     




    #DRAW Trigger line
    if(records.statusID=="OK"):       
        if(data.run==False):  #show trigger level stored in record
            paint.setPen(QtGui.QColor("gray"))
            y=(data.Ysize-(records.Trigger*data.Yscale))-2
            paint.drawLine(1, y-15, 781, y-15)  #Trigger line
            paint.drawText(760, y-17, str(records.Trigger)) #Trigger level
            paint.drawText(5, 15, str(data.Yscale)) #Y scale
        paint.setPen(QtGui.QColor("white"))
        y=(data.Ysize-(data.Trigger*data.Yscale))-2
        paint.drawLine(1, y-15, 781, y-15)  #Trigger line
        paint.drawText(760, y-17, str(data.Trigger)) #Trigger level
        paint.drawText(5, 15, str(data.Yscale)) #Y scale
       
       
       
       
    #beep in test mode
    if(peak>records.Trigger): #if last value is over peak
        if(data.QuickMode==True and (records.Index-data.Derivation)>data.last_beep): #quick mode for testing but only once per move
            print "Beep"
            data.last_beep=records.Index
            if(data.demo==False): #make beep for testing movement                    
                b = os.popen("pacat --channels=2 /usr/share/sounds/ui-default_beep.wav")
                b.close()

# ######## END of showGraph ################################################




    
def ScrollbarData():        
    Xscale=data.arrXscale[data.Xscale]
    data.GraphLen=(records.LastIndex+5)/Xscale
    if(data.GraphLen==0): data.GraphLen=1 #prevent divisions by zero
    data.GraphEnd=min(records.LastIndex+5,  data.GraphStart+779*Xscale-data.Derivation)
    
    if(data.GraphEnd<=data.Derivation): return [0,  100]
    
    p0=float(data.GraphStart)*100/data.GraphLen/Xscale
    p1=float(data.GraphEnd)*100/data.GraphLen/Xscale
    p1=min(100,  p1)
    print "--------------------"
    print "Scroll bar is on %:", p0, "...", p1 
    print "records.LastIndex:",  records.LastIndex
    print "data.GraphLen:",  data.GraphLen
    print "data.GraphEnd:",  data.GraphEnd
    return [p0,  p1]







def InitRecord():
    print "Reset/clear all record data"
    records.Index=0    
    records.LastIndex=0
    records.StartTime_tuple=time.localtime()
    records.StartTime_seconds=Tuple2Seconds(records.StartTime_tuple)
    records.AlarmTime_tuple=-1
    records.AlarmTime_seconds=-1
    records.AlarmTimeWindowStart_tuple=-1
    records.AlarmTimeWindowStart_seconds=-1
    records.AlarmTimeWindowEnd_tuple=-1
    records.AlarmTimeWindowEnd_seconds=-1
    records.AlarmTimeWindow_minutes=-1
    records.AlarmIsSet=False
    records.Note=""
    records.Sampling_interval=-1
    records.Sample_smoothing=-1
    records.Value_smoothing=-1
    records.Trigger=-1
    records.status=""
    records.statusID=""
    
    for i in range(0, records.MaxArrayDataLen-1): #clear data of old records
        for j in range(0,  4): 
            records.arrData[j][i]=0
        records.arrData[5][i]=""
    
    
    
    
    
    




# # Only used for debugging
def PrintRecordData(ShowArray=True):
    print "###################### RECORD DATA #######################"
    print "Index:",  records.Index    
    print "LastIndex:",  records.LastIndex
    print "StartTime_tuple:",  records.StartTime_tuple
    print "StartTime_seconds:",  records.StartTime_seconds
    print "AlarmTime_tuple:",  records.AlarmTime_tuple
    print "AlarmTime_seconds:",  records.AlarmTime_seconds
    print "AlarmTimeWindowStart_tuple:",  records.AlarmTimeWindowStart_tuple
    print "AlarmTimeWindowStart_seconds:",  records.AlarmTimeWindowStart_seconds
    print "AlarmTimeWindowEnd_tuple:",  records.AlarmTimeWindowEnd_tuple
    print "AlarmTimeWindowEnd_seconds",  records.AlarmTimeWindowEnd_seconds
    print "AlarmTimeWindow_minutes:",  records.AlarmTimeWindow_minutes
    print "AlarmIsSet:",  records.AlarmIsSet
    print "Note:",  records.Note
    print "Sampling_interval:",  records.Sampling_interval
    print "Sample_smoothing:",  records.Sample_smoothing
    print "Value_smoothing:",  records.Value_smoothing
    print "Trigger:",  records.Trigger
    print "Status:",  records.statusID,  records.status
    
    if(ShowArray==True):
        for i in range(0, records.Index): #print data of  records
            print records.arrData[0][i],  records.arrData[1][i],  records.arrData[2][i],  records.arrData[3][i],  records.arrData[4][i],  records.arrData[5][i]

    print "##########################################################"
    


    
