import sys
import os
import random
import time
from time import strftime
import math
import array
import string

import ConfigParser
import os, os.path

import data

from myFunctions import * #Own functions




###########################################################################
# Read the sensor data x times and smoothen it
###########################################################################
def ReadAccSensor():    
    coords=[0, 0]    
    if(data.demo==0):        
        for i in range(data.sample_smoothing):
            f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", 'r' )
            coords_tmp = [int(w) for w in f.readline().split()]
            f.close()
            coords[0]=coords[0] + coords_tmp[0] #X
            coords[1]=coords[1] + coords_tmp[1] #Y
        coords[0]=coords[0] / data.sample_smoothing
        coords[1]=coords[1] / data.sample_smoothing
    else:
        coords[0]=int(random.uniform(-50,50))
        coords[1]=int(random.uniform(-50,50))

#    print coords[0],  coords[1]
    return coords








###########################################################################
# Get the smoothened sensor data, smoothen it again and fill the data into the main data array
###########################################################################
def GetSensorData():    
    d=ReadAccSensor()
    data.arrDataTemp[0]=data.arrDataTemp[0]+d[0]
    data.arrDataTemp[1]=data.arrDataTemp[1]+d[1]

    data.sample_index=data.sample_index+1
    
    if(data.sample_index==data.value_smoothing): #if is 10 runs over        
        data.sample_index=0
        data.arrDataIndex=data.values_total % data.arrDataLen
        data.values_total=data.values_total+1
        
        data.arrData[0][data.arrDataIndex]=strftime("%H:%M:%S", time.localtime())
        data.arrData[1][data.arrDataIndex]=data.arrDataTemp[0]/data.value_smoothing
        data.arrData[2][data.arrDataIndex]=data.arrDataTemp[1]/data.value_smoothing

        data.arrDataTemp[0]=0
        data.arrDataTemp[1]=0

#        print "smoothened:",  data.arrData[1][data.arrDataIndex],  data.arrData[2][data.arrDataIndex]
        return 1 #added new values to arrData     (interval: sampling*sample_smoothing*value_smoothing)
    else: return 0 #no new data added












###########################################################################
#  Process the data, generate movement indication
###########################################################################
def ProcessData():
    #DERIVATION (ABLEITUNG)
    Show_passed_time("ProcessData Start")
#        print i,  data.arrData[0][i] ,  data.arrData[1][i],  data.arrData[2][i]  
    for i in range(0, data.arrDataIndex-data.derivation):
        data.arrData[3][i]=data.arrData[1][i+data.derivation] - data.arrData[1][i] #X  in 5 sec - X now
        data.arrData[4][i]=data.arrData[2][i+data.derivation] - data.arrData[2][i] #Y  in 5 sec - Y now
#        print i,  i+data.derivation,  data.arrData[3][i],  data.arrData[4][i]


#    lastmovement=0
#    for i in range(0, data.arrDataIndex-data.derivation):
##        data.arrData[6][i]=lastmovement
#        if((abs(data.arrData[3][i])+abs(data.arrData[4][i]))>data.trigger):
#            data.arrData[5][i]=1
##            lastmovement=i
#        else:
#            data.arrData[5][i]=0



#debug
#    for i in range(0, data.arrDataIndex-data.derivation):
#        if(data.arrData[5][i]==1): x="======="
#        else: x="|"
#        print i,  data.arrData[0][i],  data.arrData[4][i],  data.arrData[5][i],  data.arrData[6][i],  x
#

    Show_passed_time("ProcessData End")






   

###########################################################################
# Show (refreshs) the graph.
# the parameter indcates on which window it will be drawn
###########################################################################
def showGraph(self,  QtGui):
        Show_passed_time("showGraph Start")
        if(data.ChangesInGraph==0): 
            if(data.debug==1): print "------>         Do not redraw, nothing changed!"
            return 
            
        data.ChangesInGraph=0
        paint = QtGui.QPainter()
        paint.begin(self)

        paint.setFont(QtGui.QFont('Decorative', 12))
        paint.setPen(QtGui.QColor("gray"))
        paint.setBrush(QtGui.QColor("black"))

        #show Graph border
        paint.drawRect(0,0,781,data.Ysize)           

        Xscale=data.arrXscale[data.Xscale]
#        print "Zoom level:",  data.Xscale
        Pixels=data.arrDataIndex/Xscale
        if(Pixels==0): Pixels=1 #prevent divisions by zero
#        data.GraphStart=(Pixels-775)*s/100

#        print "GraphStart:",  data.GraphStart

#        x=data.arrDataIndex/Xscale
#        if(x>775): 
#            data.GraphStart=(x-775)*Xscale
#            if(data.debug==1): print "Graph too long, only show values",  data.GraphStart,  "to",  x
#        else: data.GraphStart=0
            
        try:
            t=string.split(data.arrData[0][data.GraphStart], ":")
            h0=int(t[0])
            m0=int(t[1])
        except:
            h0=int(strftime("%H", time.localtime()))
            m0=int(strftime("%M", time.localtime()))
#        print "Start time of graph:",  h0,  m0

        
        
        
        #draw Xscale
        paint.setPen(QtGui.QColor("white"))
        
        #decade:
        #6 => 60px/h
        #1 => 360px/h
        decade=360/Xscale
        minutestonexthour=60-m0
        offset=minutestonexthour*decade/60
        
        
        
        #main lines + text
        if(data.test==0):
            for i in range(-1*decade, 781+decade,  decade):
                paint.drawLine(i+offset, data.Ysize, i+offset, data.Ysize+10)  
                for k in range(1, 6):
                    x=i+offset+k*decade/6-decade
                    paint.drawLine(x, data.Ysize, x, data.Ysize+5)  
                h=(h0+int(i/decade)+1) % 24
                paint.drawText(i+offset-15, data.Ysize+30, str(h)+":00") 
                if(data.Xscale==0): #add extra marks/numbers on biggest zoom level
                    paint.drawText(i+offset-15+0.5*decade/3, data.Ysize+30, str(h)+":10") 
                    paint.drawText(i+offset-15+decade/3, data.Ysize+30, str(h)+":20") 
                    paint.drawText(i+offset-15+1.5*decade/3, data.Ysize+30, str(h)+":30") 
                    paint.drawText(i+offset-15+2*decade/3, data.Ysize+30, str(h)+":40") 
                    paint.drawText(i+offset-15+2.5*decade/3, data.Ysize+30, str(h)+":50") 
                    for k in range(1, 12): paint.drawLine(x+decade/12*k, data.Ysize, x+decade/12*k, data.Ysize+5)
        else: #test mode, do not show X scale as it is not calibrated
            paint.drawText(200, data.Ysize+20, "Test Mode")


        #trigger line
#        print "data.trigger:",  data.trigger
        y=(data.Ysize-(data.trigger*data.Yscale))-2
        paint.drawLine(1, y-15, 781, y-15)  
        paint.drawText(760, y-17, str(data.trigger))
        
        #show Y scale
        paint.drawText(5, 15, str(data.Yscale))





        #scroll bar 
        start=data.GraphStart
        end=start+775
        if(data.debug==1): print start,  "(",  start*100/Pixels, "%)",  end,  "(",  end*100/Pixels, "%)", Pixels
        if(start>0 or end<Pixels): #only draw if scroll bar needed
            paint.setPen(QtGui.QColor("gray"))
            paint.drawRect(0,data.Ysize+37,776,7)
            paint.setPen(QtGui.QColor("white"))
            paint.setBrush(QtGui.QColor("white"))
            paint.drawRect(start*779/Pixels,data.Ysize+38,(end-start)*779/Pixels,5)



        #draw graph
        lastmove=0
#        print data.GraphStart,  data.arrDataIndex-data.derivation,  Xscale
        
        end=data.arrDataIndex-data.GraphStart-data.derivation
        peak=0   
        for i in range(0,  end,  Xscale):
            k=i+data.GraphStart



            #when Xscale is small, we have to merge several records into 1 pixel.
            #To not miss any movement, we use the biggest movement of the merged records:
            peak=0            
            paint.setPen(QtGui.QColor("yellow"))
            for j in range(0, Xscale):
#                Show_passed_time("L 1")
                p=abs(data.arrData[3][k])+abs(data.arrData[4][k])
                if(p>peak): peak=p
   
    
    
            Y=peak*data.Yscale
            if(Y>=data.Ysize-17): 
                Y=data.Ysize-17
            paint.drawLine(i/Xscale+1, data.Ysize-Y-1-15, i/Xscale+1, data.Ysize-1-15)  
            
            
            if(peak>data.trigger or i>=end-Xscale):



                x0=lastmove/Xscale+1
                x1=i/Xscale-1
                len=x1-x0
#                if(len==0): len=1
                if(x0<=x1):
                    t=(x1-x0)*Xscale/6          
#                        print x0,  "<=>",  x1,  t,  Xscale
                    if(t>30): color="#009100" #green
                    elif(t>15): color="#005000" #dark green
                    elif(t>7): color="#97320e" #orange
                    else: color="#6D0000" #dark red       
#                    print "draw rect with color",  color                  
                    paint.setBrush(QtGui.QColor(color))
                    paint.setPen(QtGui.QColor(color))
                    paint.drawRect(x0+1, data.Ysize-11, len, 10)                     
                    paint.setPen(QtGui.QColor("yellow"))
#                        print "=     Draw field",  x0,  x1,  data.Ysize,  color
                lastmove=i
                
        
        if(peak>data.trigger): #if last value is over peak
            if(data.QuickMode==1 and (end-data.derivation)>data.last_beep): #quick mode for testing but only once pr move
                if(data.demo==0): #make beep for testing movement
                    b = os.popen("pacat --channels=2 /usr/share/sounds/ui-default_beep.wav")
                    b.close()
                    data.last_beep=end

        Show_passed_time("showGraph End")











###########################################################################
# Function to measure used time in a function
###########################################################################
def Show_passed_time(text=""):
#    global passed_time
    if(data.debug==0): return
    now=time.time()
    t=1000*(now-data.passed_time)
    print "+++++++++",  str(int(t)), "ms: ", text

    data.passed_time = time.time()






