import sys
import os
import random
import time
from time import strftime
import math
import array
import string

import ConfigParser
import os, os.path

import data

from myFunctions import * #Own functions

try:
    import alarm #maemo specific
except:
    pass




###########################################################################
# Read the sensor data x times and smoothen it
###########################################################################
def ReadAccSensor():    
    coords=[0, 0]    
    if(data.demo==0):        
        for i in range(data.sample_smoothing):
            f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", 'r' )
            coords_tmp = [int(w) for w in f.readline().split()]
            f.close()
            coords[0]=coords[0] + coords_tmp[0] #X
            coords[1]=coords[1] + coords_tmp[1] #Y
        coords[0]=coords[0] / data.sample_smoothing
        coords[1]=coords[1] / data.sample_smoothing
    else:
        coords[0]=int(random.uniform(-50,50))
        coords[1]=int(random.uniform(-50,50))

#    print coords[0],  coords[1]
    return coords








###########################################################################
# Get the smoothened sensor data, smoothen it again and fill the data into the main data array
###########################################################################
def GetSensorData():    
    d=ReadAccSensor()
    data.arrDataTemp[0]=data.arrDataTemp[0]+d[0]
    data.arrDataTemp[1]=data.arrDataTemp[1]+d[1]

    data.sample_index=data.sample_index+1
    
    if(data.sample_index==data.value_smoothing): #if is 10 runs over        
        data.sample_index=0
        data.arrDataIndex=data.values_total % data.arrDataLen
        data.values_total=data.values_total+1
        
        data.arrData[0][data.arrDataIndex]=strftime("%H:%M:%S", time.localtime())
        data.arrData[1][data.arrDataIndex]=data.arrDataTemp[0]/data.value_smoothing
        data.arrData[2][data.arrDataIndex]=data.arrDataTemp[1]/data.value_smoothing

        data.arrDataTemp[0]=0
        data.arrDataTemp[1]=0

#        print "smoothened:",  data.arrData[1][data.arrDataIndex],  data.arrData[2][data.arrDataIndex]
        return 1 #added new values to arrData
        
        print "Added data to array with index",  data.arrDataIndex
        
    else: return 0 #no new data added












###########################################################################
#  Process the data, generate movement indication
###########################################################################
def ProcessData(ProcessAll=False):
    #DERIVATION (ABLEITUNG)
    Show_passed_time("ProcessData Start")
#        print i,  data.arrData[0][i] ,  data.arrData[1][i],  data.arrData[2][i]  

    lastmove=0 
    if(ProcessAll==True): start=0
    else: start=data.arrDataIndex-data.derivation-1
    for i in range(start, data.arrDataIndex-data.derivation):     
        t=i*(data.interval*data.value_smoothing)/1000
#        print t,  data.DelayStartTime,  data.QuickMode
        if(data.QuickMode==1 or t>data.DelayStartTime):
            Xder=data.arrData[1][i+data.derivation] - data.arrData[1][i] #X  in 5 sec - X now
            Yder=data.arrData[2][i+data.derivation] - data.arrData[2][i]  #Y  in 5 sec - Y now
            XYder=abs(Xder)+abs(Yder) #summ of both absolute derivations
        else: #During delayed phase, do not use data
#            print "Drop derivation, still in Start delay"
            Xder=0
            Yder=0
            XYder=0
        data.arrData[3][i]=min(XYder*data.Yscale,  data.Ysize-17) #cut off if higer than graph border

    Show_passed_time("ProcessData End")





   

###########################################################################
# Show (refreshs) the graph.
# the parameter indcates on which window it will be drawn
###########################################################################
def showGraph(self,  QtGui):
        if(data.ChangesInGraph==0): 
            if(data.debug==1): print "------>         Do not redraw, nothing changed!"
            return 
        Show_passed_time("showGraph Start")
#        print "showGraph"
#        print "Array Index:",  data.arrDataIndex
            
        data.ChangesInGraph=0
        paint = QtGui.QPainter()
        paint.begin(self)

        paint.setFont(QtGui.QFont('Decorative', 12))
        paint.setPen(QtGui.QColor("white"))
        paint.setBrush(QtGui.QColor("black"))

        #show Graph border
        paint.drawRect(0,0,781,data.Ysize)                  

        Xscale=data.arrXscale[data.Xscale]
#        print "Zoom level:",  data.Xscale
        GraphLen=data.arrDataIndex/Xscale
        if(GraphLen==0): GraphLen=1 #prevent divisions by zero
#        print "GraphLen:",  GraphLen
            
        try:
            t=string.split(data.arrData[0][data.GraphStart], ":")
            h0=int(t[0])
            m0=int(t[1])
        except:
#            Now=int(strftime("%H", time.localtime()))*3600+int(strftime("%M", time.localtime()))*60 #nows h+m in secs
#            h0=int(math.floor(Now/3600))
#            m0=int((Now-h0*3600)/60)

            h0=int(time.strftime("%H", time.localtime()))
            m0=int(time.strftime("%M", time.localtime()))
            
#            print "Graph will start at",  Now,  t            
#        print "Start time of graph:",  h0,  ":",  m0
                
        #decade:
        #6 => 60px/h
        #1 => 360px/h
        decade=360/Xscale
        minutestonexthour=60-m0
        offset=minutestonexthour*decade/60
        
        Show_passed_time("showGraph Preparations done")
        
        
        # ##############################################
        #DRAW main scaling lines + text        
        paint.setPen(QtGui.QColor("white"))
#        if(data.test==0):
        if(data.QuickMode==0): #normal mode
            for i in range(-1*decade, 781+decade,  decade):
                paint.drawLine(i+offset, data.Ysize, i+offset, data.Ysize+10)  
                for k in range(1, 6):
                    x=i+offset+k*decade/6-decade
                    paint.drawLine(x, data.Ysize, x, data.Ysize+5)  
                h=(h0+int(i/decade)+1) % 24
                paint.drawText(i+offset-15, data.Ysize+30, str(h)+":00") 
                if(data.Xscale==0): #add extra marks/numbers on biggest zoom level
                    paint.drawText(i+offset-15+0.5*decade/3, data.Ysize+30, str(h)+":10") 
                    paint.drawText(i+offset-15+decade/3, data.Ysize+30, str(h)+":20") 
                    paint.drawText(i+offset-15+1.5*decade/3, data.Ysize+30, str(h)+":30") 
                    paint.drawText(i+offset-15+2*decade/3, data.Ysize+30, str(h)+":40") 
                    paint.drawText(i+offset-15+2.5*decade/3, data.Ysize+30, str(h)+":50") 
                    for k in range(1, 12): paint.drawLine(x+decade/12*k, data.Ysize, x+decade/12*k, data.Ysize+5)
        else: #test mode, do not show X scale as it is not calibrated
            paint.drawText(200, data.Ysize+20, "Test Mode")


        #DRAW scroll bar 
#        start=data.GraphStart
        end=data.GraphStart+775
        if(data.debug==1): print data.GraphStart,  "(",  data.GraphStart*100/GraphLen, "%)",  end,  "(",  end*100/GraphLen, "%)", GraphLen
        if(data.GraphStart>0 or end<GraphLen): #only draw if scroll bar needed
            paint.setPen(QtGui.QColor("gray"))
            paint.drawRect(0,data.Ysize+37,776,7)
            paint.setPen(QtGui.QColor("white"))
            paint.setBrush(QtGui.QColor("white"))
            paint.drawRect(data.GraphStart*779/GraphLen,data.Ysize+38,(end-data.GraphStart)*779/GraphLen,5)

        Show_passed_time("showGraph Frame+variouse line/texts done")







        # ##############################################
        #DRAW graph
        end=min(data.arrDataIndex,  data.GraphStart+779*Xscale)
        end=end-data.derivation
#        print "Graph Start:",data.GraphStart, ",  End:",  end,  data.arrData[0][data.GraphStart],  data.arrData[0][end]
        paint.setPen(QtGui.QColor("yellow"))        
        lastmove=0        
        peak=0
        
        
        for m in range(data.GraphStart,  0,  -1):    #find last peak before shown graph
            if(data.arrData[3][m]>data.trigger): 
                lastmove=m-data.GraphStart
#                print "time bar start before graph:",  m,  data.arrData[0][m]
                break

        
        lastdatapoint=data.arrDataIndex
        for p in range(data.GraphStart,  end,  Xscale):
#            print p,  data.arrData[0][p]
            if(data.arrData[0][p]=="0"): 
#                print "break,  reached time with 0:",  p
                lastdatapoint=p
                break
            i=p-data.GraphStart
            #when Xscale is small, we have to merge several records into 1 pixel.
            #Too not miss any movement, we use the biggest movement of the merged records:
            peak=0            
            for j in range(0, Xscale): 
                if(data.arrData[3][p+j]>peak): peak=data.arrData[3][p+j]

            paint.drawLine(i/Xscale+1, data.Ysize-peak-1-15, i/Xscale+1, data.Ysize-1-15)  #draw yellow movement bar

            #draw time bars
            if(peak>data.trigger): 
                x0=lastmove/Xscale+1
                x1=i/Xscale-1
                if(x0<=x1):
                    t=(x1-x0)*Xscale/6          
                    if(t>30): color="#009100" #green
                    elif(t>15): color="#005000" #dark green
                    elif(t>7): color="#97320e" #orange
                    else: color="#6D0000" #dark red                   
                    paint.setBrush(QtGui.QColor(color))
                    paint.setPen(QtGui.QColor(color))
#                    print "time bar:",  x0,  x1,  lastmove+data.GraphStart,  i+data.GraphStart,   data.arrData[0][lastmove+data.GraphStart],  data.arrData[0][i+data.GraphStart]
                    paint.drawRect(x0+1, data.Ysize-11, x1-x0, 10)                     
                    paint.setPen(QtGui.QColor("yellow"))
                lastmove=i
                
                
          

        #draw last time bar
#        for m in range(end-1,  data.arrDataIndex):    #find first peak after shown graph
#        print "Search for end of last time line"
#        print end-1,  "lastdatapoint:",  lastdatapoint
#        for m in range(max(end-1, lastdatapoint),  data.arrDataIndex):    #find first peak after shown graph
        for m in range(end,  data.arrDataIndex):    #find first peak after shown graph
#            if(data.arrData[0][m]=="0"): 
##                print "break,  reached time with 0",  p
##                break
#                pass
            if(data.arrData[3][m]>data.trigger or m>=data.arrDataIndex-Xscale or m==lastdatapoint):
                x0=lastmove/Xscale+1
#                print m,  lastdatapoint
#                m=min(m,  lastdatapoint)
#                x1=(m-data.derivation)/Xscale-data.GraphStart
                x1=min(lastdatapoint/Xscale, (m-data.derivation)/Xscale-data.GraphStart)
#                print x0,  x1
#                print "first time bar end after graph:", x0,  x1,  lastmove,  lastmove+data.GraphStart,  m,   data.arrData[0][lastmove+data.GraphStart],  data.arrData[0][i]
                if(x0<=x1 and x0>=0):
                    t=(x1-x0)*Xscale/6          
                    if(t>30): color="#009100" #green
                    elif(t>15): color="#005000" #dark green
                    elif(t>7): color="#97320e" #orange
                    else: color="#6D0000" #dark red                   
                    paint.setBrush(QtGui.QColor(color))
                    paint.setPen(QtGui.QColor(color))
                    x1=min(x1,  775) #limit to end of graph
                    print "draw line",  x0,  "-",  x1
                    paint.drawRect(x0+1, data.Ysize-11, x1-x0, 10)          
                break
           
        
           

        # ##############################################
        #ALARM VISUALISATION
#        print data.AlarmHour,  data.AlarmMinute,  data.QuickMode
#        if(data.AlarmHour>-1 and  data.AlarmMinute>-1 and data.QuickMode==0): #we are recording normaly and an alarm is set, or we loaded a record with set alarm
        if(data.AlarmIsSet==True and data.QuickMode==0): #we are recording normaly and an alarm is set, or we loaded a record with set alarm
#            timediff=(data.AlarmTimeSec - (data.StartTimeSec+data.DelayStartTime)) #diff until alarm
            timediff=(data.AlarmTimeSec - data.StartTimeSec) #diff until alarm
            t=(data.interval*data.value_smoothing)/1000
#            print data.interval,  data.value_smoothing,  t,  data.StartTimeSec
            IndexAlarm=int(timediff/t)
#            print "IndexAlarm:",  IndexAlarm,  timediff,  t,  data.AlarmTimeSec,  data.StartTimeSec
#            timediff2=(data.AlarmTimeSec - (data.StartTimeSec+data.DelayStartTime)) - data.AlarmTimeWindow*60 #diff until alarm - AlarmTimeWindow
            timediff2=(data.AlarmTimeSec - data.StartTimeSec) - data.AlarmTimeWindow*60 #diff until alarm - AlarmTimeWindow
            IndexAlarm2=int(timediff2/t)
            
#            print "First index will be at (absolute secs)", data.StartTimeSec+data.DelayStartTime
#            print "First index will be at (absolute secs)", data.StartTimeSec
#            print "Alarm is in seconds after recording start:",  timediff,  ", AlarmTimeWindow:",  timediff2
#            print "Index for Alarm will be at",  IndexAlarm,  "AlarmTimeWindow:",  IndexAlarm2 #divided by 10 (1 index = 10secs
#            print "Draw Alarm data:",  data.AlarmHour,":",   data.AlarmMinute,  data.AlarmIsSet,  data.AlarmTimeWindow,  data.AlarmIsActive
#            print "GraphStart", data.GraphStart,  "Graph End:",  (data.GraphStart+755*Xscale)
            
            paint.setBrush(QtGui.QColor("Orange"))
            paint.setPen(QtGui.QColor("Orange"))            
            
            x1=(IndexAlarm-data.GraphStart)/Xscale #set alarm position in graph 
            x0=(IndexAlarm2-data.GraphStart)/Xscale #AlarmTimeWindow position in graph
            
#            print x0,  x1 ,  IndexAlarm,  data.GraphStart 
            #Draw alarm set point
            if(IndexAlarm>=data.GraphStart and IndexAlarm<=(data.GraphStart+755*Xscale)): #show in graph
#                print "Set Alarm:",  x1
                paint.drawRect(x1-1,  4,  2,  10) 
        
            #draw AlarmTimeWindow
#            print "AlarmTimeWindow (uncorrected):",  x0,  "-",  x1
#            x0=max(x0, data.GraphStart)
#            x0=min(x0, (data.GraphStart+755*Xscale))            
#            x1=max(x1, x0)
#            x1=min(x1, (data.GraphStart+755*Xscale))
#            print "AlarmTimeWindow:",  x0,  "-",  x1
            if((x1-x0)>0): paint.drawRect(x0,  8,  x1-x0,  2) #Time Window 
            


#            Alarm=-1
            paint.setBrush(QtGui.QColor("red"))
            paint.setPen(QtGui.QColor("red"))
            for i in range(0,  data.arrDataIndex):
                if(data.arrData[5][i]=="Alarm"):
#                    print "Found Alarm entry on index:",  x
                    x=(i-data.GraphStart)/Xscale              
                    paint.drawEllipse(x-5, 15, 10, 10)             
           
           
           
           
           
           
           
        # ##############################################
       #DRAW trigger line
        paint.setPen(QtGui.QColor("white"))
#        paint.setBrush(QtGui.QColor("white"))
        y=(data.Ysize-(data.trigger*data.Yscale))-2
        paint.drawLine(1, y-15, 781, y-15)  #trigger line
        paint.drawText(760, y-17, str(data.trigger)) #trigger level
        paint.drawText(5, 15, str(data.Yscale)) #Y scale
           
           
           
           
        # ##############################################
        #beep in test mode
        if(peak>data.trigger): #if last value is over peak
            if(data.QuickMode==1 and (end-data.derivation)>data.last_beep): #quick mode for testing but only once pr move
                if(data.demo==0): #make beep for testing movement
                    b = os.popen("pacat --channels=2 /usr/share/sounds/ui-default_beep.wav")
                    b.close()
                    data.last_beep=end

        Show_passed_time("showGraph End")








###########################################################################
# Function to measure used time in a function
###########################################################################
def Show_passed_time(text="",  reset=0):
    if(data.debug==0): return
    now=time.time()
    if(reset==1): data.passed_time=now
    
    t=1000*(now-data.passed_time)
    t2=1000*(now-data.passed_time2)
    print "### ",  str(int(t)), "ms, (",  str(int(t2)), "ms delta): ", text

    data.passed_time2 = time.time()









def SetAlarm(hour,  minute):
    if(data.demo==0): #We are on a N900
        event = alarm.Event()
        event.appid = 'SleepAnalyser'
        event.message = 'Wake up!'   
    else:
        print "Can not set alarm, Maemo interface not available"
    
#    print "Set alarm to: "+str(data.AlarmHour)+":"+str(data.AlarmMinute)
    
    h=int(strftime("%H", time.localtime()))
    m=int(strftime("%M", time.localtime()))
#    alarmdiff=getSecondsUntilAlarm(h, m)
    now=h*3600+m*60
    al=int(hour)*3600+int(minute)*60
    alarmdiff=al-now
    if(alarmdiff<0):  #set to tomorrow if time already is elapsed today
        alarmdiff=alarmdiff+86400
    
    if(data.demo==0): #We are on a N900
        event.alarm_time = time.mktime(time.localtime()) + alarmdiff

        action_stop, action_snooze = event.add_actions(2)
        action_stop.label = 'Stop'
        action_stop.flags |= alarm.ACTION_WHEN_RESPONDED | alarm.ACTION_TYPE_NOP

        action_snooze.label = 'Snooze'
        action_snooze.flags |= alarm.ACTION_WHEN_RESPONDED | alarm.ACTION_TYPE_SNOOZE

#       print event.is_sane()
        data.AlarmID = alarm.add_event(event)

        #check if set correctly
        event = alarm.get_event(data.AlarmID)
        print "* Alarm will go off on:",  time.ctime(event.trigger)
#    print ""

    data.AlarmIsSet=True







def DeleteAlarm():
    if(data.AlarmID!=-1): #there is an old alarm to be deleted
        if(data.demo==0): #We are on a N900
            try:
                event = alarm.get_event(data.AlarmID) #get data of to be deleted alarm
                alarm.delete_event(data.AlarmID)
                print "* Delete old Alarm:",  time.ctime(event.trigger)
            except:
                pass
            data.AlarmID=-1
        else:
            print "Can not delete alarm, Maemo interface not available"
            
    else:
        print "* No alarm to be deleted"        
        
    
    data.AlarmIsSet=False





def InitAlarm():
#add note to array for graph
#    if(data.arrDataIndex==0 and data.AlarmIsSet==True): #do only on first time and if alarm is set
#        print "first loop run",  data.arrData[0][0]
#    t=string.split(data.arrData[0][0],  ":")

    print "Initialize Alarm visualisation"

#    print "StartTime:",  data.StartTime, "Alarm:",   data.AlarmHour,  data.AlarmMinute
    now=int(strftime("%H", data.StartTime))*3600+int(strftime("%M", data.StartTime))*60
    al=int(data.AlarmHour)*3600+int(data.AlarmMinute)*60
    alarmdiff=al-now
    if(alarmdiff<0):  #set to tomorrow if time already is elapsed today
        alarmdiff=alarmdiff+86400
    
    i=alarmdiff/10
    
    if(i<data.arrDataLen): 
        data.arrData[5][i]="Alarm Time Window End" #Last oportunity for alarm
        print "Set Alarm Time Window End:",  i
#            if(i-data.AlarmTimeWindow*6>0):
        i=max(i-6*data.AlarmTimeWindow, 0)
        data.arrData[5][i]="Alarm Time Window Begin" #First oportunity for alarm
        print "Set Alarm Time Window Begin:",  i
    else:
        print "EventSetAlarm is out of range"
        
#        print "Set Alarm time (index) to:",  i-data.AlarmTimeWindow*6,  "-",  i,  data.AlarmTimeWindow



def ProcessAlarm():
    i=data.arrDataIndex-data.derivation            
    if(i>1): peak=data.arrData[3][i-1]
    else: peak=0
    h=int(strftime("%H", time.localtime()))
    m=int(strftime("%M", time.localtime()))
    Now=h*60+m
    Alarm=int(data.AlarmHour)*60+int(data.AlarmMinute)
#    print "Peak:",  peak,  data.trigger Al
    if(peak>data.trigger): #big Movement
#        Now=int(strftime("%H", time.localtime()))*60+int(strftime("%M", time.localtime()))
#        Al=int(data.AlarmHour)*60+int(data.AlarmMinute)
#        print "Now:", Now,  "Alarm:", Al,  "AlarmTimeWindow:", data.AlarmTimeWindow, "AlarmIsSet:", data.AlarmIsSet, "AlarmIsActive:",  data.AlarmIsActive
        if(data.AlarmIsSet==True and data.AlarmIsActive==False and  Now>(Alarm-data.AlarmTimeWindow) and Now<=Alarm): #We are in alarm time window and alarm is set and not active yet
            print "************ ALARM ALARM *********************"
            data.AlarmIsActive=True
#            print "Mark alarm in array on index:",  data.arrDataIndex-1
            if(data.arrData[5][data.arrDataIndex-1]==0): data.arrData[5][data.arrDataIndex-1]="Alarm"    
            else: data.arrData[5][data.arrDataIndex-2]="Alarm"    
            DeleteAlarm() #delete old alarm if existing
            print "* Set new Alarm to current time:",  h,  ":",  m
            SetAlarm(h,  m) #set alarm to go off now
#            return 1
    elif(Now==Alarm): #End of alarm time window, set alarm off anyway
        if(data.AlarmIsSet==True and data.AlarmIsActive==False): #Alarm is set and not active yet
            print "************ ALARM ALARM *********************"
            data.AlarmIsActive=True
            if(data.arrData[5][data.arrDataIndex-1]==0): data.arrData[5][data.arrDataIndex-1]="Alarm"    
            else: data.arrData[5][data.arrDataIndex-2]="Alarm"    
#            return 1
#    else: return 0
    
    
    
    
    

    
