import sys
import os
import random
import time
from time import strftime
import math
import array
import string

import ConfigParser
import os, os.path

import data

from myFunctions import * #Own functions




###########################################################################
# Read the sensor data x times and smoothen it
###########################################################################
def ReadAccSensor():    
    coords=[0, 0]    
    if(data.demo==0):        
        for i in range(data.sample_smoothing):
            f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", 'r' )
            coords_tmp = [int(w) for w in f.readline().split()]
            f.close()
            coords[0]=coords[0] + coords_tmp[0] #X
            coords[1]=coords[1] + coords_tmp[1] #Y
        coords[0]=coords[0] / data.sample_smoothing
        coords[1]=coords[1] / data.sample_smoothing
    else:
        coords[0]=int(random.uniform(-50,50))
        coords[1]=int(random.uniform(-50,50))

    print coords[0],  coords[1]
    return coords








###########################################################################
# Get the smoothened sensor data, smoothen it again and fill the data into the main data array
###########################################################################
def GetSensorData():    
    d=ReadAccSensor()
    data.arrDataTemp[0]=data.arrDataTemp[0]+d[0]
    data.arrDataTemp[1]=data.arrDataTemp[1]+d[1]

    data.sample_index=data.sample_index+1
    
    if(data.sample_index==data.value_smoothing): #if is 10 runs over        
        data.sample_index=0
        data.arrDataIndex=data.values_total % data.arrDataLen
        data.values_total=data.values_total+1
        
        data.arrData[0][data.arrDataIndex]=strftime("%H:%M:%S", time.localtime())
        data.arrData[1][data.arrDataIndex]=data.arrDataTemp[0]/data.value_smoothing
        data.arrData[2][data.arrDataIndex]=data.arrDataTemp[1]/data.value_smoothing

        data.arrDataTemp[0]=0
        data.arrDataTemp[1]=0

        print "smoothened:",  data.arrData[1][data.arrDataIndex],  data.arrData[2][data.arrDataIndex]
        return 1 #added new values to arrData     (interval: sampling*sample_smoothing*value_smoothing)
    else: return 0 #no new data added












###########################################################################
#  Process the data, generate movement indication
###########################################################################
def ProcessData():
    #DERIVATION (ABLEITUNG)
    Show_passed_time("ProcessData Start")
#        print i,  data.arrData[0][i] ,  data.arrData[1][i],  data.arrData[2][i]  
    for i in range(0, data.arrDataIndex-data.derivation):
        data.arrData[3][i]=data.arrData[1][i+data.derivation] - data.arrData[1][i] #X  in 5 sec - X now
        data.arrData[4][i]=data.arrData[2][i+data.derivation] - data.arrData[2][i] #Y  in 5 sec - Y now
#        print i,  i+data.derivation,  data.arrData[3][i],  data.arrData[4][i]


#    lastmovement=0
#    for i in range(0, data.arrDataIndex-data.derivation):
##        data.arrData[6][i]=lastmovement
#        if((abs(data.arrData[3][i])+abs(data.arrData[4][i]))>data.trigger):
#            data.arrData[5][i]=1
##            lastmovement=i
#        else:
#            data.arrData[5][i]=0



#debug
#    for i in range(0, data.arrDataIndex-data.derivation):
#        if(data.arrData[5][i]==1): x="======="
#        else: x="|"
#        print i,  data.arrData[0][i],  data.arrData[4][i],  data.arrData[5][i],  data.arrData[6][i],  x
#

    Show_passed_time("ProcessData End")






   

###########################################################################
# Show (refreshs) the graph.
# the parameter indcates on which window it will be drawn
###########################################################################
def showGraph(self,  QtGui):
        Show_passed_time("showGraph Start")
        if(data.ChangesInGraph==0): 
            if(data.debug==1): print "------>         Do not redraw, nothing changed!"
            return 
            
        data.ChangesInGraph=0
        paint = QtGui.QPainter()
        paint.begin(self)

        paint.setFont(QtGui.QFont('Decorative', 12))
        paint.setPen(QtGui.QColor("gray"))
        paint.setBrush(QtGui.QColor("black"))

        #show Graph border
        paint.drawRect(0,0,781,data.Ysize)           

        Xscale=data.arrXscale[data.Xscale]
#        print "Zoom level:",  data.Xscale

        x=data.arrDataIndex/Xscale
        if(x>775): 
            GraphStart=(x-775)*Xscale
            print "Graph too long, only show values",  GraphStart,  "to",  x
        else: GraphStart=0
            
        try:
            t=string.split(data.arrData[0][GraphStart], ":")
            h0=int(t[0])
            m0=int(t[1])
        except:
            h0=int(strftime("%H", time.localtime()))
            m0=int(strftime("%M", time.localtime()))
#        print "Start time of graph:",  h0,  m0

        
        
        
        #draw Xscale
        paint.setPen(QtGui.QColor("white"))
        
        #decade:
        #6 => 60px/h
        #1 => 360px/h
        decade=360/Xscale
        minutestonexthour=60-m0
        offset=minutestonexthour*decade/60
        
        
        
        #main lines + text
        if(data.test==0):
            for i in range(0, 781+decade,  decade):
                paint.drawLine(i+offset, data.Ysize, i+offset, data.Ysize+10)  
                for k in range(1, 6):
                    x=i+offset+k*decade/6-decade
                    paint.drawLine(x, data.Ysize, x, data.Ysize+5)  
                h=(h0+int(i/decade)+1) % 24
                paint.drawText(i+offset-20, data.Ysize+30, str(h)+":00") 
        else: #test mode, do not show X scale as it is wrong
            paint.drawText(200, data.Ysize+20, "Test Mode")


        #trigger line
        y=(data.Ysize-(data.trigger*data.Yscale))-2
        paint.drawLine(1, y-15, 781, y-15)  
        paint.drawText(760, y-17, str(data.trigger))
        
        #show y scale
        paint.drawText(5, 15, str(data.Yscale))



        #draw graph
        lastmove=0
#        print GraphStart,  data.arrDataIndex-data.derivation,  Xscale
        
        end=data.arrDataIndex-GraphStart-data.derivation
        peak=0   
        for i in range(0,  end,  Xscale):
            k=i+GraphStart
            
            
            
            #when Xscale is small, we have to merge several records into 1 pixel.
            #To not miss any movement, we use the biggest movement of the merged records:
            peak=0            
            paint.setPen(QtGui.QColor("yellow"))
            for j in range(0, Xscale):
#                Show_passed_time("L 1")
                p=abs(data.arrData[3][k])+abs(data.arrData[4][k])
                if(p>peak): peak=p
           
            
            
            
#            if(1): #one or more movement for this pixel
#                peak=abs(data.arrData[3][k])+abs(data.arrData[4][k])
            Y=peak*data.Yscale
            if(Y>=data.Ysize+17): 
                Y=data.Ysize-17
#                print "too big:",  Y,  peak*data.Yscale
            #Draw movement line
#            paint.setBrush(QtGui.QColor("yellow"))
            paint.drawLine(i/Xscale+1, data.Ysize-Y-1-15, i/Xscale+1, data.Ysize-1-15)  
            
            
            #fill space between yellow movement lines
#                if(k>lastmove+1):k
#            print i,  end,  Xscale
            if(peak>data.trigger or i>=end-Xscale):
#            if(peak>data.trigger):
                
                        
                        
#                Show_passed_time("L 2")
##                    1=10 sec
#                    if((i-lastmove)>30*Xscale): color="#009100" #green
#                    elif((i-lastmove)>15*Xscale): color="#005000" #dark green
#                    t=(i-lastmove)*Xscale
#                    print t,  30*Xscale
#                    if(t>30): color="#009100" #green
#                    elif(t>15): color="#005000" #dark green
#                    else: color="#6D0000" #dark red 

                x0=lastmove/Xscale+1
                x1=i/Xscale-1
                if(x0<x1):
                    t=(x1-x0)*Xscale/6          
#                        print x0,  "<=>",  x1,  t,  Xscale
                    if(t>30): color="#009100" #green
                    elif(t>15): color="#005000" #dark green
                    else: color="#6D0000" #dark red       
#                    print "draw rect with color",  color                  
                    paint.setBrush(QtGui.QColor(color))
                    paint.setPen(QtGui.QColor(color))
                    paint.drawRect(x0+1, data.Ysize-11, x1-x0+1, 10)                     
                    paint.setPen(QtGui.QColor("yellow"))
#                        print "=     Draw field",  x0,  x1,  data.Ysize,  color
                lastmove=i
                
                
        
        if(peak>data.trigger): #if last value is over peak
            if(data.Mode==1 and (end-data.derivation)>data.last_beep): #quick mode for testing but only once pr move
                if(data.demo==0): #make beep for testing movement
                    b = os.popen("pacat --channels=2 /usr/share/sounds/ui-default_beep.wav")
                    b.close()
                    data.last_beep=end

        Show_passed_time("showGraph End")











###########################################################################
# Function to measure used time in a function
###########################################################################
def Show_passed_time(text=""):
#    global passed_time
    if(data.debug==0): return
    now=time.time()
    t=1000*(now-data.passed_time)
    print "+++++++++",  str(int(t)), "ms: ", text

    data.passed_time = time.time()






